\name{binmod.plot}
\docType{methods}
\alias{PAS.binmod.plot}
\alias{binmod.plot}
\alias{plot}
\alias{plot.binmod} 
\title{
plot function
}
\description{
Generate figures using an object created by the binmod function.
}
\usage{
\method{plot}{binmod}(x, file=NULL, width=7, height=5, getdata=FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{An object generated by the binnod function.}
  \item{file}{The prefix of the figure files to be saved.}
  \item{width}{width of the figures (inch).}
  \item{height}{height of the figures (inch).}
  \item{getdata}{A logic indicator. The default value is FALSE, which mean not to return the data for plotting.}
  \item{...}{Further graphical parameters may also be supplied as arguments.}
}
\examples{
#load PAS library
library (PAS)
#load the demo data
data(beef)
#conduct bin model analysis and plotting the result.
plot(binmod(x, y, map))
}
