% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGram.R
\name{plotGram}
\alias{plotGram}
\title{Plot Spectrogram or Cepstrogram}
\usage{
plotGram(
  x,
  evNum = 1,
  start = NULL,
  end = NULL,
  channel = 1,
  wl = 512,
  hop = 0.25,
  mode = c("spec", "ceps"),
  detections = c("cepstrum", "click", "whistle"),
  detCol = c("red", "blue", "blue"),
  sr = NULL
)
}
\arguments{
\item{x}{an \linkS4class{AcousticStudy} object}

\item{evNum}{if \code{x} is a study, the event index number to calculate the average
spectra for. Note that this is the index in the order that they appear in the
\linkS4class{AcousticStudy} object, not the actual event number. Alternatively
full event names can be used}

\item{start}{start time of the plot, either POSIXct or seconds from
the start of the event}

\item{end}{end time of the plot, either POSIXct or seconds from the start
of the event.}

\item{channel}{channel to plot}

\item{wl}{window length of FFT to use for creating plot}

\item{hop}{hop value of FFT to use for creating plot, either as a percentage
of \code{wl} or number of samples}

\item{mode}{one of \code{'spec'} or \code{'ceps'} to plot either spectrogram
or cepstrogram}

\item{detections}{vector containing any of \code{'cepstrum'}, \code{'click'},
and/or \code{'whistle'} indicating which detections to overlay on the plot}

\item{detCol}{vector containing colors to use for plotting detections. Order matches
order of detections (default alphabetical - cepstrum, click, whistle)}

\item{sr}{sample rate}
}
\value{
nothing, just plots
}
\description{
Plots either a spectrogram or cepstrogram and also overlays
  whistle or cepstral contours from the binary files
}
\examples{

data(exStudy)
recs <- system.file('extdata', 'Recordings', package='PAMpal')
exStudy <- updateFiles(exStudy,
                       bin=system.file('extdata', 'Binaries', package='PAMpal'),
                       db = system.file('extdata', 'Example.sqlite3', package='PAMpal'))
exStudy <- addRecordings(exStudy, folder=recs, log=FALSE, progress=FALSE)
# No detections will appear on plot because included recordings are heavily decimated
plotGram(exStudy)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
