% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sclongitudinalDEG.R
\name{sclongitudinalDEG}
\alias{sclongitudinalDEG}
\title{sclongitudinalDEG Function}
\usage{
sclongitudinalDEG(
  data_object,
  scassay = "RNA",
  group_column,
  group_oi = NULL,
  mincellsexpressed = 0.1,
  removelnc = "TRUE",
  adjfac = NULL,
  baseline = NULL,
  addCDR = FALSE,
  CDR_column = NULL,
  plotWidth = 10,
  plotHeight = 10,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information and expression data from Bulk or single cell data.}

\item{scassay}{Single cell assay from scRNA seurat object (Default 'RNA')}

\item{group_column}{Column of interest such as 'celltype' to analyze DEGs in
participant over time}

\item{group_oi}{Features of interest such as  specific celltypes c('CD4_Naive',
'CD4_TEM')}

\item{mincellsexpressed}{Average expression threshold to filter lowly expressed
genes/features Default is 0.1}

\item{removelnc}{Remove lincRNAs, mitochondrial and ribosomal genes from
analysis incldes (^RP|^MT-|^LINC|orf) (TRUE/FALSE). Default is TRUE}

\item{adjfac}{Factors to be adjusted for such as batch, sex}

\item{baseline}{Donors (PTID) to be considered as baseline. Deafult NULL}

\item{addCDR}{(Optional) Add CDR while performing differential analysis.
Default is FALSE}

\item{CDR_column}{(Optional) cellular detection rate column name}

\item{plotWidth}{User-defined plot width, Default 10 in}

\item{plotHeight}{User-defined plot height, Default 10 in}

\item{fileName}{User-defined file name, Default outputFile}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current
directory}
}
\value{
PALMO object with deg list
}
\description{
This function allows ser to calculate differential expressed genes in the
direction of given time points (if timepoints>3 otherwise DEGs between two
timepoints). A hurdle model was fit to each participant independently in
order to identify participant-specific longitudinal transcriptomic changes.
Genes that were expressed in at least 10\% of cells per participant were
considered for this analysis. The models were fit on the input normalized
data, modeling the timepoints as a continuous variable within each cell type
and adjusting for the batch only if any timepoints from the same participant
were run across multiple batches.
}
\examples{
\dontrun{
palmo_obj <- sclongitudinalDEG(ann=metadata, dataObj=pbmc, scassay='RNA', group_column='celltype')
}
}
\keyword{sclongitudinalDEG}
