% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OralOpioids.R
\name{MED_90}
\alias{MED_90}
\title{Maximum number of units/millilitres of oral opioids allowed per day assuming a daily limit of 90 MED/day for a DIN from the HealthCanada Opioid Table by using the DIN}
\usage{
MED_90(Drug_ID, HealthCanada_Opioid_Table)
}
\arguments{
\item{Drug_ID}{A numeric value for the DIN. Exclude all zeros in front}

\item{HealthCanada_Opioid_Table}{Health Canada opioid dataset which can be loaded by using
the \code{load_HealthCanada_Opioid_Table()} function. Please run \code{load_HealthCanada_Opioid_Table()} function. The name you use to call the function should be input here.}
}
\value{
no. of units to reach 90 MED
}
\description{
\code{MED_90} gives us the maximum number of units (e.g. tablets or capsules for solid oral opioids and no. of millilitres for liquid oral opioids that are safe assuming a Morphine equivalent Dose of 90.)
}
\examples{

HealthCanada_Opioid_Table <- load_HealthCanada_Opioid_Table(no_download = TRUE)
MED_90(786535, HealthCanada_Opioid_Table)
}
