% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_intens.R
\name{smooth_intens}
\alias{smooth_intens}
\alias{smooth_intens.default}
\alias{smooth_intens.OpenSpecy}
\title{Smooth spectral intensities}
\usage{
smooth_intens(x, ...)

\method{smooth_intens}{default}(x, ...)

\method{smooth_intens}{OpenSpecy}(
  x,
  polynomial = 3,
  window = 11,
  derivative = 1,
  abs = TRUE,
  make_rel = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{OpenSpecy}.}

\item{polynomial}{polynomial order for the filter}

\item{window}{number of data points in the window, filter length (must be
odd).}

\item{derivative}{the derivative order if you want to calculate the
derivative. Zero (default) is no derivative.}

\item{abs}{logical; whether you want to calculate the absolute value of the
resulting output.}

\item{make_rel}{logical; if \code{TRUE} spectra are automatically normalized
with \code{\link{make_rel}()}.}

\item{\ldots}{further arguments passed to \code{\link[signal]{sgolay}()}.}
}
\value{
\code{smooth_intens()} returns an \code{OpenSpecy} object.
}
\description{
This smoother can enhance the signal to noise ratio of the data and uses a
Savitzky-Golay filter with a running window of data points and the polynomial
specified.
}
\details{
This is a wrapper around the filter function in the signal package to improve
integration with other Open Specy functions.
A typical good smooth can be achieved with 11 data point window and a 3rd or
4th order polynomial.
}
\examples{
data("raman_hdpe")

smooth_intens(raman_hdpe)

}
\references{
Savitzky A, Golay MJ (1964). “Smoothing and Differentiation of Data by
Simplified Least Squares Procedures.” \emph{Analytical Chemistry},
\strong{36}(8), 1627--1639.
}
\seealso{
\code{\link[signal]{sgolay}()}
}
\author{
Win Cowger, Zacharias Steinmetz
}
