% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repgrid-constructs.r
\name{constructs}
\alias{constructs}
\alias{constructs<-}
\alias{leftpoles}
\alias{leftpoles<-}
\alias{rightpoles}
\alias{rightpoles<-}
\title{Get or replace construct poles}
\usage{
constructs(x, collapse = FALSE, sep = " - ")

constructs(x, i, j) <- value

leftpoles(x)

leftpoles(x, position) <- value

rightpoles(x)

rightpoles(x, position) <- value
}
\arguments{
\item{x}{A repgrid object.}

\item{collapse}{Return vector with both poles instead.}

\item{sep}{Separator if \code{collapse = TRUE}, default is \code{" - "}.}

\item{i, j}{Row and column Index of repgrid matrix.}

\item{value}{Character vector of construct poles names.}

\item{position}{Index where to insert construct}
}
\description{
Allows to get and set construct poles.
Replaces the older functions \code{getConstructNames}, \code{getConstructNames2},
and \code{eNames} which are deprecated.
}
\examples{

# shorten object name
x <- boeker

## get construct poles
constructs(x)   # both left and right poles
leftpoles(x)    # left poles only
rightpoles(x)
constructs(x, collapse = TRUE)

## replace construct poles
constructs(x)[1,1] <- "left pole 1"
constructs(x)[1,"leftpole"] <- "left pole 1"  # alternative
constructs(x)[1:3,2] <- paste("right pole", 1:3)
constructs(x)[1:3,"rightpole"] <- paste("right pole", 1:3) # alternative
constructs(x)[4,1:2] <- c("left pole 4", "right pole 4")

l <- leftpoles(x)
leftpoles(x) <- sample(l)             # brind poles into random order
leftpoles(x)[1] <- "new left pole 1"  # replace name of first left pole

# replace left poles of constructs 1 and 3
leftpoles(x)[c(1,3)] <- c("new left pole 1", "new left pole 3")
 
}
