% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,ANY,ANY-method}
\alias{plot,Interval,ANY-method}
\alias{plot,Category,ANY-method}
\alias{plot,Transition,ANY-method}
\title{Methods for function \code{plot} in package \pkg{OpenLand}}
\usage{
plot(x, y, ...)

\S4method{plot}{Interval,ANY}(
  x,
  y,
  labels = c(leftlabel = "Interval Change Area (percent of map)", rightlabel =
    "Annual Change Area (percent of map)"),
  title = NA,
  labs = c(type = "Changes", ur = "Uniform Intensity"),
  marginplot = c(lh = -10, rh = 0),
  leg_curv = c(x = 0.1, y = 0.1),
  color_bar = c(fast = "#B22222", slow = "#006400", area = "gray40"),
  fontsize_ui = 10,
  ...
)

\S4method{plot}{Category,ANY}(
  x,
  y,
  labels = c(leftlabel = "Annual Change Area (km2 or pixels)", rightlabel =
    "Annual Change Intensity (percent of category)"),
  title = NA,
  labs = c(type = "Categories", ur = "Uniform Intensity"),
  marginplot = c(lh = 0.5, rh = 0.5),
  leg_curv = c(x = 0.1, y = 0.1),
  fontsize_ui = 10,
  ...
)

\S4method{plot}{Transition,ANY}(
  x,
  y,
  labels = c(leftlabel = "Annual Transition Area (km2 or pixels)", rightlabel =
    "Annual Transition Intensity (percent of category)"),
  title = NA,
  labs = c(type = "Categories", ur = "Uniform Intensity"),
  marginplot = c(lh = 0.5, rh = 0.5),
  leg_curv = c(x = 0.1, y = 0.1),
  fontsize_ui = 10,
  ...
)
}
\arguments{
\item{x}{An intensity object generated by \code{\link{intensityAnalysis}}.}

\item{y}{ignored.}

\item{\dots}{additional arguments for theme parameters from ggplot2, see
\code{\link[ggplot2]{theme}}.}

\item{labels}{character. Left and right axis titles(caption).}

\item{title}{character. Main title.}

\item{labs}{character. The lateral legend.}

\item{marginplot}{numeric. Adjustment of the origins of left and right part of
the plots.}

\item{leg_curv}{numeric. x and y values that control the arrow size and position
pointing to the Uniform Intensity vertical line.}

\item{color_bar}{character. Colors defined for the fast, slow and area bars
(only for an \code{\linkS4class{Interval}} object).}

\item{fontsize_ui}{numeric. Fontsize of the uniform intensity percent in the plot.}

\item{Interval}{The class.}

\item{Category}{The class.}

\item{Transition}{The class.}
}
\value{
An intensity graph
}
\description{
Plot \code{Intensity} objects based on Intensity Analysis output.
}
\keyword{methods}
\keyword{plot}
