% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gabor_feature_extraction.R
\docType{class}
\name{GaborFeatureExtract}
\alias{GaborFeatureExtract}
\title{Gabor Feature Extraction}
\usage{
# init <- GaborFeatureExtract$new()
}
\description{
Gabor Feature Extraction

Gabor Feature Extraction
}
\details{
In case of an RGB image (3-dimensional where the third dimension is equal to 3) one can use the \emph{rgb_2gray()} to convert the image to a 2-dimensional one

I added the option \emph{downsample_gabor} to the original matlab code based on the following question on stackoverflow : \emph{https://stackoverflow.com/questions/49119991/feature-extraction-with-gabor-filters}
}
\section{Methods}{


\describe{
 \item{\code{GaborFeatureExtract$new()}}{}

 \item{\code{--------------}}{}

 \item{\code{gabor_filter_bank(scales, orientations, gabor_rows, gabor_columns, plot_data = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{gabor_feature_extraction(image, scales, orientations, gabor_rows, gabor_columns, downsample_gabor = FALSE, plot_data = FALSE,
                                      downsample_rows = NULL, downsample_cols = NULL, normalize_features = FALSE, threads = 1, vectorize_magnitude = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{gabor_feature_engine(img_data, img_nrow, img_ncol, scales, orientations, gabor_rows, gabor_columns, downsample_gabor = FALSE,
                                  downsample_rows = NULL, downsample_cols = NULL, normalize_features = FALSE, threads = 1, verbose = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{plot_gabor(real_matrices, margin_btw_plots = 0.15, thresholding = FALSE)}}{}

 \item{\code{--------------}}{}

 \item{\code{plot_multi_images(list_images, par_ROWS, par_COLS)}}{}

 \item{\code{--------------}}{}
}
}

\examples{

library(OpenImageR)

init_gb = GaborFeatureExtract$new()

# gabor-filter-bank
#------------------

gb_f = init_gb$gabor_filter_bank(scales = 5, orientations = 8, gabor_rows = 39,

                                 gabor_columns = 39, plot_data = TRUE)


# plot gabor-filter-bank
#-----------------------

plt_f = init_gb$plot_gabor(real_matrices = gb_f$gabor_real, margin_btw_plots = 0.65,

                           thresholding = FALSE)


# read image
#-----------

pth_im = system.file("tmp_images", "car.png", package = "OpenImageR")

im = readImage(pth_im) * 255


# gabor-feature-extract
#----------------------

# gb_im = init_gb$gabor_feature_extraction(image = im, scales = 5, orientations = 8,

#                                          downsample_gabor = TRUE, downsample_rows = 3,

#                                          downsample_cols = 3, gabor_rows = 39, gabor_columns = 39,

#                                          plot_data = TRUE, normalize_features = FALSE,

#                                          threads = 6)


# plot real data of gabor-feature-extract
#----------------------------------------

# plt_im = init_gb$plot_gabor(real_matrices = gb_im$gabor_features_real, margin_btw_plots = 0.65,

#                             thresholding = FALSE)


# feature generation for a matrix of images (such as the mnist data set)
#-----------------------------------------------------------------------

ROWS = 13; COLS = 13; SCAL = 3; ORIEN = 5; nrow_mt = 500; im_width = 12; im_height = 15

set.seed(1)
im_mt = matrix(sample(1:255, nrow_mt * im_width * im_height, replace = TRUE), nrow = nrow_mt,

                      ncol = im_width * im_height)

# gb_ex = init_gb$gabor_feature_engine(img_data = im_mt, img_nrow = im_width, img_ncol = im_height,

#                                      scales = SCAL, orientations = ORIEN, gabor_rows = ROWS,

#                                      gabor_columns = COLS, downsample_gabor = FALSE,

#                                      downsample_rows = NULL, downsample_cols = NULL,

#                                      normalize_features = TRUE, threads = 1, verbose = FALSE)


# plot of multiple image in same figure
#---------------------------------------

list_images = list(im, im, im)

plt_multi = init_gb$plot_multi_images(list_images, par_ROWS = 2, par_COLS = 2)

}
\references{
https://github.com/mhaghighat/gabor

https://stackoverflow.com/questions/20608458/gabor-feature-extraction

https://stackoverflow.com/questions/49119991/feature-extraction-with-gabor-filters
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GaborFeatureExtract-new}{\code{GaborFeatureExtract$new()}}
\item \href{#method-GaborFeatureExtract-gabor_filter_bank}{\code{GaborFeatureExtract$gabor_filter_bank()}}
\item \href{#method-GaborFeatureExtract-gabor_feature_extraction}{\code{GaborFeatureExtract$gabor_feature_extraction()}}
\item \href{#method-GaborFeatureExtract-gabor_feature_engine}{\code{GaborFeatureExtract$gabor_feature_engine()}}
\item \href{#method-GaborFeatureExtract-plot_gabor}{\code{GaborFeatureExtract$plot_gabor()}}
\item \href{#method-GaborFeatureExtract-plot_multi_images}{\code{GaborFeatureExtract$plot_multi_images()}}
\item \href{#method-GaborFeatureExtract-clone}{\code{GaborFeatureExtract$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GaborFeatureExtract-new"></a>}}
\if{latex}{\out{\hypertarget{method-GaborFeatureExtract-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GaborFeatureExtract$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GaborFeatureExtract-gabor_filter_bank"></a>}}
\if{latex}{\out{\hypertarget{method-GaborFeatureExtract-gabor_filter_bank}{}}}
\subsection{Method \code{gabor_filter_bank()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GaborFeatureExtract$gabor_filter_bank(
  scales,
  orientations,
  gabor_rows,
  gabor_columns,
  plot_data = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scales}}{a numeric value. Number of scales (usually set to 5)     ( gabor_filter_bank function )}

\item{\code{orientations}}{a numeric value. Number of orientations (usually set to 8)     ( gabor_filter_bank function )}

\item{\code{gabor_rows}}{a numeric value. Number of rows of the 2-D Gabor filter (an odd integer number, usually set to 39 depending on the image size)     ( gabor_filter_bank function )}

\item{\code{gabor_columns}}{a numeric value. Number of columns of the 2-D Gabor filter (an odd integer number, usually set to 39 depending on the image size)       ( gabor_filter_bank function )}

\item{\code{plot_data}}{either TRUE or FALSE. If TRUE then data needed for plotting will be returned     ( gabor_filter_bank, gabor_feature_extraction functions )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GaborFeatureExtract-gabor_feature_extraction"></a>}}
\if{latex}{\out{\hypertarget{method-GaborFeatureExtract-gabor_feature_extraction}{}}}
\subsection{Method \code{gabor_feature_extraction()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GaborFeatureExtract$gabor_feature_extraction(
  image,
  scales,
  orientations,
  gabor_rows,
  gabor_columns,
  downsample_gabor = FALSE,
  plot_data = FALSE,
  downsample_rows = NULL,
  downsample_cols = NULL,
  normalize_features = FALSE,
  threads = 1,
  verbose = FALSE,
  vectorize_magnitude = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{a 2-dimensional image of type matrix    ( gabor_feature_extraction function )}

\item{\code{scales}}{a numeric value. Number of scales (usually set to 5)     ( gabor_filter_bank function )}

\item{\code{orientations}}{a numeric value. Number of orientations (usually set to 8)     ( gabor_filter_bank function )}

\item{\code{gabor_rows}}{a numeric value. Number of rows of the 2-D Gabor filter (an odd integer number, usually set to 39 depending on the image size)     ( gabor_filter_bank function )}

\item{\code{gabor_columns}}{a numeric value. Number of columns of the 2-D Gabor filter (an odd integer number, usually set to 39 depending on the image size)       ( gabor_filter_bank function )}

\item{\code{downsample_gabor}}{either TRUE or FALSE. If TRUE then downsampling of data will take place. The \emph{downsample_rows} and \emph{downsample_cols} should be adjusted accordingly. Downsampling does not affect the output plots but the output \emph{gabor_features}     ( gabor_feature_extraction function )}

\item{\code{plot_data}}{either TRUE or FALSE. If TRUE then data needed for plotting will be returned     ( gabor_filter_bank, gabor_feature_extraction functions )}

\item{\code{downsample_rows}}{either NULL or a numeric value specifying the factor of downsampling along rows    ( gabor_feature_extraction function )}

\item{\code{downsample_cols}}{either NULL or a numeric value specifying the factor of downsampling along columns    ( gabor_feature_extraction function )}

\item{\code{normalize_features}}{either TRUE or FALSE. If TRUE then the output gabor-features will be normalized to zero mean and unit variance    ( gabor_feature_extraction function )}

\item{\code{threads}}{a numeric value specifying the number of threads to use    ( gabor_feature_extraction function )}

\item{\code{verbose}}{either TRUE or FALSE. If TRUE then information will be printed in the console    ( gabor_feature_extraction, gabor_feature_engine functions )}

\item{\code{vectorize_magnitude}}{either TRUE or FALSE. If TRUE the computed magnitude feature will be returned in the form of a vector, otherwise it will be returned as a list of matrices  ( gabor_feature_extraction function )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GaborFeatureExtract-gabor_feature_engine"></a>}}
\if{latex}{\out{\hypertarget{method-GaborFeatureExtract-gabor_feature_engine}{}}}
\subsection{Method \code{gabor_feature_engine()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GaborFeatureExtract$gabor_feature_engine(
  img_data,
  img_nrow,
  img_ncol,
  scales,
  orientations,
  gabor_rows,
  gabor_columns,
  downsample_gabor = FALSE,
  downsample_rows = NULL,
  downsample_cols = NULL,
  normalize_features = FALSE,
  threads = 1,
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{img_data}}{a numeric matrix specifying the input data (gabor_feature_engine function)}

\item{\code{img_nrow}}{an integer specifying the number of rows of the input matrix (gabor_feature_engine function)}

\item{\code{img_ncol}}{an integer specifying the number of columns of the input matrix (gabor_feature_engine function)}

\item{\code{scales}}{a numeric value. Number of scales (usually set to 5)     ( gabor_filter_bank function )}

\item{\code{orientations}}{a numeric value. Number of orientations (usually set to 8)     ( gabor_filter_bank function )}

\item{\code{gabor_rows}}{a numeric value. Number of rows of the 2-D Gabor filter (an odd integer number, usually set to 39 depending on the image size)     ( gabor_filter_bank function )}

\item{\code{gabor_columns}}{a numeric value. Number of columns of the 2-D Gabor filter (an odd integer number, usually set to 39 depending on the image size)       ( gabor_filter_bank function )}

\item{\code{downsample_gabor}}{either TRUE or FALSE. If TRUE then downsampling of data will take place. The \emph{downsample_rows} and \emph{downsample_cols} should be adjusted accordingly. Downsampling does not affect the output plots but the output \emph{gabor_features}     ( gabor_feature_extraction function )}

\item{\code{downsample_rows}}{either NULL or a numeric value specifying the factor of downsampling along rows    ( gabor_feature_extraction function )}

\item{\code{downsample_cols}}{either NULL or a numeric value specifying the factor of downsampling along columns    ( gabor_feature_extraction function )}

\item{\code{normalize_features}}{either TRUE or FALSE. If TRUE then the output gabor-features will be normalized to zero mean and unit variance    ( gabor_feature_extraction function )}

\item{\code{threads}}{a numeric value specifying the number of threads to use    ( gabor_feature_extraction function )}

\item{\code{verbose}}{either TRUE or FALSE. If TRUE then information will be printed in the console    ( gabor_feature_extraction, gabor_feature_engine functions )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GaborFeatureExtract-plot_gabor"></a>}}
\if{latex}{\out{\hypertarget{method-GaborFeatureExtract-plot_gabor}{}}}
\subsection{Method \code{plot_gabor()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GaborFeatureExtract$plot_gabor(
  real_matrices,
  margin_btw_plots = 0.65,
  thresholding = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{real_matrices}}{a list of 3-dimensional arrays (where the third dimension is equal to 3). These arrays correspond to the \emph{real part} of the complex output matrices      ( plot_gabor function )}

\item{\code{margin_btw_plots}}{a float between 0.0 and 1.0 specifying the margin between the multiple output plots      ( plot_gabor function )}

\item{\code{thresholding}}{either TRUE or FALSE. If TRUE then a threshold of 0.5 will be used to push values above 0.5 to 1.0 ( similar to otsu-thresholding )      ( plot_gabor function )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GaborFeatureExtract-plot_multi_images"></a>}}
\if{latex}{\out{\hypertarget{method-GaborFeatureExtract-plot_multi_images}{}}}
\subsection{Method \code{plot_multi_images()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GaborFeatureExtract$plot_multi_images(
  list_images,
  par_ROWS,
  par_COLS,
  axes = FALSE,
  titles = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{list_images}}{a list containing the images to plot  ( plot_multi_images function )}

\item{\code{par_ROWS}}{a numeric value specifying the number of rows of the plot-grid  ( plot_multi_images function )}

\item{\code{par_COLS}}{a numeric value specifying the number of columns of the plot-grid  ( plot_multi_images function )}

\item{\code{axes}}{a boolean. If TRUE then the X- and Y-range of values (axes) will appear in the output images  ( plot_multi_images function )}

\item{\code{titles}}{either NULL or a character vector specifying the main-titles of the output images. The length of this vector must be the same as the length of the input 'list_images' parameter  ( plot_multi_images function )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GaborFeatureExtract-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GaborFeatureExtract-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GaborFeatureExtract$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
