% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot_sub1_study_state}
\alias{plot_sub1_study_state}
\title{Plots the study state of a given subset design.}
\usage{
plot_sub1_study_state(sr, enrolledPat = data.frame(ep1 = logical(), ep2 =
  logical()), r1, n1, r, s, n)
}
\arguments{
\item{sr}{dataframe containing the stopping rules for the given subset design defined by 3 columns named "Enrolled_patients", "Needed_responses_ep1" and "Needed_responses_ep2".
This way each row defines when the study has to be stopped for futility.}

\item{enrolledPat}{dataframe defined by two boolean vectors named "ep1" and "ep2" indicating which patient had a response in the subset and superset endpoint.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{r}{critical value for the subset endpoint.}

\item{s}{critical value for the superset endpoint.}

\item{n}{overall sample size.}
}
\description{
Plots the study state of a given subset design displaying the already enrolled patients and the stopping rules for the given study.
}
\examples{
\dontrun{
#Calculate a subset design.
sub1 <- setupSub1Design(alpha = 0.1, beta = 0.2, pc0 = 0.3, pt0 = 0.4)
design <- getSolutionsSub1(sub1)$Solutions[10,]
#Define the stopping rules according to the chosen design.
sr <- data.frame(Enrolled_patients = c(design$n1, design$n),
Needed_responses_ep1 = c(design$r1, design$r), Needed_responses_ep2 = c(0,design$s))
#Simulate 14 random generated outcomes.
tmp_ep1 <- rbinom(14,1, design$pc1)
tmp_ep2 <- tmp_ep1 | rbinom(14,1, design$pt1)
enrolledPat <- data.frame(ep1 = tmp_ep1, ep2 = tmp_ep2)
#Plot study state.
plot_sub1_study_state(sr, enrolledPat, design$r1, design$n1, design$r, design$s, design$n)
}
}
\seealso{
\code{\link{getSolutionsSub1}}
}

