% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appStatic.R
\name{exportStaticApp}
\alias{exportStaticApp}
\title{Export and launch a static shiny specific to the provided results.}
\usage{
exportStaticApp(
  result,
  directory,
  logo = "ohdsi",
  title = "",
  background = TRUE,
  summary = TRUE,
  panels = list(),
  theme = NULL,
  open = rlang::is_interactive()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{directory}{Directory to create the shiny.}

\item{logo}{Name of a logo or path to a logo. If NULL no logo is included.
Only svg format allowed for the moment.}

\item{title}{title of the shiny}

\item{background}{Whether to include a background panel. Background panel
content will be controlled from the generated background.md file.}

\item{summary}{Whether to include a panel with a summary of content in the
`result`.}

\item{panels}{List specifying order of results. Each panel is determined
by the available result types in the result object. Panels for any available
results not specified will be included after the specified result tabs.}

\item{theme}{Assign a theme to the shiny app using bslib::bs_theme()}

\item{open}{Whether to open the shiny app project.}
}
\value{
The shiny app will be created in directory.
}
\description{
Export and launch a static shiny specific to the provided results.
}
\examples{
exportStaticApp(
  result = emptySummarisedResult(),
  directory = tempdir(),
  theme = "bslib::bs_theme(bg = '#bb0a1e', fg = '#0000ff')"
)

}
