% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableConceptIdCounts.R
\name{tableConceptIdCounts}
\alias{tableConceptIdCounts}
\title{Create a visual table from a summariseConceptIdCounts() result.}
\usage{
tableConceptIdCounts(result, display = "overall", type = "reactable")
}
\arguments{
\item{result}{A summarised_result object.}

\item{display}{A character string indicating which subset of the data to display. Options are:
\itemize{
\item \code{"overall"}: Show all source and standard concepts.
\item \code{"standard"}: Show only standard concepts.
\item \code{"source"}: Show only source codes.
\item \code{"missing standard"}: Show only source codes that are missing a mapped standard concept.
}}

\item{type}{Type of formatting output table, either "reactable" or "datatable".}
}
\value{
A reactable or datatable object with the summarised data.
}
\description{
Create a visual table from a summariseConceptIdCounts() result.
}
\examples{
\donttest{
library(OmopSketch)
library(CDMConnector)
library(duckdb)

requireEunomia()
con <- dbConnect(duckdb(), eunomiaDir())
cdm <- cdmFromCon(con = con, cdmSchema = "main", writeSchema = "main")

result <- summariseConceptIdCounts(cdm = cdm, omopTableName = "condition_occurrence")
tableConceptIdCounts(result = result, display = "standard")
}
}
