% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCa.R
\name{BCa}
\alias{BCa}
\title{BCa}
\usage{
BCa(Boot, data, alphalower = 0.025, alphaupper = 0.975,
  accelleration = "jack", FUN, ...)
}
\arguments{
\item{Boot}{A vector of bootstrap estimates of Theta}

\item{data}{The data that was analyzed via the bootstrap}

\item{alphalower}{The lower alpha for CI creation}

\item{alphaupper}{The upper alpha for CI creation}

\item{accelleration}{can currently take two values, "jack" and "bootstrap". "jack" returns the jackknife estimate of the accelleration parameter. "boot" is an experimental function that uses the bootstrap estimates in the calculation of the accelleration parameter. "boot" is many times faster (approximately n times faster where n is the number of observations).}

\item{FUN}{The function used to get estimates of Theta}

\item{...}{Additional arguments to FUN}
}
\value{
A matrix of BCa bootstrap CI's, the bias parameter and the accellation parameter
}
\description{
BCa
}
\examples{
data<-DFSimulated()
boots<-NaiveBoot(data, groups="Rs", keepgroups=TRUE)
boots<-bootAnalysis(boots, cbind, DFanalysis, 1,2,3, robust=FALSE)
BCa(boots, data, .025,.975, accelleration="bootstrap", DFanalysis, 1,2,3, robust=FALSE)

}
