/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.creator;

import java.util.Map;
import nu.xom.Node;
import org.andwellness.xml.datagenerator.creator.DataPointCreator;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.apache.log4j.Logger;

public class HoursBeforeNowDataPointCreator
extends DataPointCreator {
    private Logger _logger = Logger.getLogger(HoursBeforeNowDataPointCreator.class);

    @Override
    public DataPoint create(Node currentNode) {
        String displayType = currentNode.query("displayType").get(0).getValue();
        String nodeId = currentNode.query("id").get(0).getValue();
        DataPoint createdDataPoint = new DataPoint();
        createdDataPoint.setId(nodeId);
        createdDataPoint.setPromptType(DataPoint.PromptType.hours_before_now);
        createdDataPoint.setDisplayType(displayType);
        Node propertyNode = currentNode.query("properties").get(0);
        Map<String, String> nodeProperties = this.extractProperties(propertyNode);
        int min = Integer.parseInt(nodeProperties.get("min"));
        int max = Integer.parseInt(nodeProperties.get("max"));
        int hoursBeforeNow = ValueCreator.randomPositiveIntModulus(max - min) + min;
        createdDataPoint.setValue(new Integer(hoursBeforeNow));
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating an hoursBeforeNow data point with id " + nodeId + " min " + min + " max " + max + " value " + hoursBeforeNow);
        }
        return createdDataPoint;
    }
}

