% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getSccsDiagnosticsData}
\alias{getSccsDiagnosticsData}
\title{Extract the self controlled case series (sccs) diagostic results}
\usage{
getSccsDiagnosticsData(
  connectionHandler,
  schema,
  sccsTablePrefix = "sccs_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  outcomeIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{sccsTablePrefix}{The prefix used for the cohort generator results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the database name}
 \item{analysisId the analysis unique identifier}
 \item{description an analysis description}
 \item{targetName the target name}
 \item{targetId the target cohort id}
 \item{outcomeName the outcome name}
 \item{outcomeId the outcome cohort id}
 \item{covariateName whether main or secondary analysis}
 \item{mdrr the maximum passable minimum detectable relative risk (mdrr) value.  If the mdrr is greater than this the diagnostics will fail.}
 \item{ease The expected absolute systematic error (ease) measures residual bias.}
 \item{timeTrendP The p for whether the mean monthly ratio between observed and expected is no greater than 1.25.}
 \item{preExposureP One-sided p-value for whether the rate before expore is higher than after, against the null of no difference.}
 \item{mdrrDiagnostic whether the mdrr (power) diagnostic passed or failed.}
 \item{easeDiagnostic whether the ease diagnostic passed or failed.}
 \item{timeTrendDiagnostic Pass / warning / fail / not evaluated classification of the time trend (unstalbe months) diagnostic.}
 \item{preExposureDiagnostic Pass / warning / fail / not evaluated classification of the time trend (unstalbe months) diagnostic.}
 \item{unblind whether the results can be unblinded.}
 \item{unblindForEvidenceSynthesis whether the results can be unblinded for the meta analysis.}
 \item{summaryValue summary of diagnostics results. FAIL, PASS or number of warnings.}
 }
}
\description{
This function extracts the sccs diagnostics that examine whether the analyses were sufficiently powered
and checks for different types of bias.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

sccsDiag <- getSccsDiagnosticsData(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetIds = 1,
  outcomeIds = 3
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
