% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{xPx}
\alias{xPx}
\title{A function to compute Bell's isolation index (xPx)}
\usage{
xPx(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A vector with isolation index
}
\description{
The isolation index is a exposure index that measures
the probability that a member of a group shares the same spatial
unit with another member of its group.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
xPx(x)
}
\references{
Bell W. (1954) \emph{A probability model for the
measurement of ecological segregation}. Social Forces 32(4),
pp. 357-364

Massey D. S. and Denton N. A. (1988) \emph{
The dimensions of residential segregation}.  Social Forces 67(2),
pp. 281-315.
}
\seealso{
Adjusted isolation index: \code{\link{Eta2}}

Interaction index: \code{\link{xPy}}
}

