% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PredictionMap}
\alias{plot.PredictionMap}
\title{Heatmap of a PredictionMap Object}
\usage{
\method{plot}{PredictionMap}(
  x = NULL,
  xlab = "samples",
  ylab = "base classifiers",
  main = "Prediction map",
  las = 1,
  srt = 30,
  cex = 1,
  cex.lab = 1,
  label.colors = NULL,
  plot.sampleIDs = FALSE,
  plot.cv.runs = TRUE,
  plot.class.labels = TRUE,
  ...
)
}
\arguments{
\item{x}{A PredictonMap object as it is returned by \code{\link{predictionMap}}-function.}

\item{xlab}{A title for the x axis (see \code{\link{plot}}).}

\item{ylab}{A title for the y axis (see \code{\link{plot}}).}

\item{main}{See \code{\link{plot}}.}

\item{las}{See \code{\link{par}}.}

\item{srt}{Angle used to rotate the strings of the x-axis and y-axis labels (see \code{\link{par}}).}

\item{cex}{See \code{\link{par}}.}

\item{cex.lab}{See \code{\link{par}}.}

\item{label.colors}{A vector of the color for the class labels. 
If NULL, automatically use rainbow color scheme.}

\item{plot.sampleIDs}{Specifices if the sample IDs should be plotted along the x axis (TRUE or FALSE).}

\item{plot.cv.runs, }{Specifices if the cross-validation runs should be plotted (TRUE or FALSE). 
Cross-validation runs are visually separated by straight lines.}

\item{plot.class.labels}{Specificies if the numerical class labels should additionally plotted (TRUE or FALSE).}

\item{...}{Further arguments passed from other methods.}
}
\value{
No return value, called to a heatmap plot of the predictionMap Object.
}
\description{
Plots a heatmap, that shows the predictions of a PredictionMap object and 
the real labels in a cross-validation or reclassification experiment.
}
\details{
This function plots a heatmap with color-decoded predictions made by the 
specified classifier.
Here, the rows indicate the different binary base classifiers and the columns the samples 
in the specified resampling experiment (reclassification or cross-validation).
Labels are visualized in the top row and decoded color-wise.
}
\examples{
library(TunePareto)
data(esl)
data <- esl$data
labels <- esl$labels
foldList <- generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap <- predictionMap(data, labels, foldList = foldList, 
                        classifier = tunePareto.svm(), kernel='linear')

plot(predMap)

}
\seealso{
\code{\link{predictionMap}}
}
