% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropSize.R
\name{dropSize}
\alias{dropSize}
\title{Filters for size}
\usage{
dropSize(subcascades = NULL, size = NA)
}
\arguments{
\item{subcascades}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.
The Subcascades object is made up of a list of matrices. 
Each matrix comprises the evaluation results of cascades of a specific length and 
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.}

\item{size}{A numeric value that defines the size of the cascades that should be returned. 
The smallest size is 2 and the largest the maximal number of classes of the current dataset.}
}
\value{
A Subcascades object as in \code{\link{subcascades}}, that does not include cascades of the specific lengths that hve been filtered.
}
\description{
Filters out the Subcascades object for the given sizes.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subc = subcascades(predMap,thresh=0.7)

# filters out cascades that have a length of 3
dropSize(subc,size=3)
# filters out cascades that have a length of 3 or 4
dropSize(subc, size=c(3,4))
}
\seealso{
\code{\link{keepSize}}, \code{\link{dropSets}}, \code{\link{keepSets}}, \code{\link{dropThreshold}}, \code{\link{keepThreshold}}
}
