% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ORFID.R
\name{import_ORFID}
\alias{import_ORFID}
\title{Import data files from Oregon RFID antenna readers}
\usage{
import_ORFID(file, delim, verbose = FALSE)
}
\arguments{
\item{file}{.txt file generated by an Oregon RFID reader.}

\item{delim}{field/column delimiter, which must be tab ('\\t'), comma (',') or semi-colon (';').}

\item{verbose}{If \emph{TRUE}, a description of the compiled data is printed to the console.}
}
\value{
Returns a tibble object of data compiled from a single ORFID data file.
}
\description{
Imports files from Oregon RFID (radio-frequency identification) ORMR (Oregon RFID Multi-Reader) and ORSR (Oregon RFID Single Reader) antenna readers. Only detections are retained during compilation (events are removed).

This function will only work with raw data downloaded directly from Oregon RFID stationary readers. The files must be delimited (tab, comma, or semicolon) and unedited by the user.
}
\details{
The field/column delimiter must be tab, comma or semi-colon for data compilation and further analysis. The function cannot be used for space delimited data. 

The tag number column (\emph{TAG}) is required for subsequent analyses, and the function will return a warning if \emph{TAG} is not included in the data file. 

Note that corruption may occur in reader data files. Check your data files and compiled data carefully to ensure accuracy.
}
\examples{

# Import a single tab-deliminated data file from an ORFID reader
import_ORFID(file = system.file("extdata/orfid_data_file.txt", package = "ORFID"), delim = "\t")

}
\author{
Hugo Marques <biohmarques@gmail.com>, Annika Putt <annika@instream.net>
}
