% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsr_te.R
\name{opsr_te}
\alias{opsr_te}
\title{Treatment Effect Computations for OPSR Model Fits}
\usage{
opsr_te(object, type, weights = NULL, ...)
}
\arguments{
\item{object}{object an object of class \code{"opsr"}.}

\item{type}{see \code{\link{predict.opsr}} for details.}

\item{weights}{a vector of weights. If \code{NULL} then weights from \code{object} will
be used.}

\item{...}{additional arguments passed to \code{\link{predict.opsr}}.}
}
\value{
An object of class \code{"opsr.te"}.
}
\description{
Treatment Effect Computations for OPSR Model Fits
}
\details{
This function only prepares the input to a further call to \code{\link{summary.opsr.te}}.
}
\examples{
sim_dat <- opsr_simulate()
dat <- sim_dat$data
weights <- runif(nrow(dat))
fit <- opsr(ys | yo ~ xs1 + xs2 | xo1 + xo2, dat = dat, weights = weights,
            printLevel = 0)
te <- opsr_te(fit, type = "response")
print(te)
summary(te)

te_w <- opsr_te(fit, type = "response", weights = rep(1, nrow(dat)))
summary(te_w)

pairs(te)
}
\seealso{
\code{\link{summary.opsr.te}}
}
