% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opi.r, R/compassClient.r, R/displayClient.r,
%   R/daydreamClient.r, R/imoClient.r, R/kowaAP7000Client.r, R/octopus600.r,
%   R/octopus900Client.r, R/phoneHMD.r, R/simG.r
\name{opiQueryDevice}
\alias{opiQueryDevice}
\alias{compass.opiQueryDevice}
\alias{display.opiQueryDevice}
\alias{daydream.opiQueryDevice}
\alias{imo.opiQueryDevice}
\alias{kowaAP7000.opiQueryDevice}
\alias{octo600.opiQueryDevice}
\alias{octo900.opiQueryDevice}
\alias{PhoneHMD.opiQueryDevice}
\alias{simG.opiQueryDevice}
\title{Query device using OPI}
\usage{
opiQueryDevice(...)

compass.opiQueryDevice()

display.opiQueryDevice()

daydream.opiQueryDevice()

imo.opiQueryDevice()

kowaAP7000.opiQueryDevice()

octo600.opiQueryDevice()

octo900.opiQueryDevice()

PhoneHMD.opiQueryDevice()

simG.opiQueryDevice()
}
\arguments{
\item{...}{Implementation specific parameters. See details.}
}
\value{
Returns a list that contains \code{isSim} and implementation-dependent
data.

\code{isSim} is \code{TRUE} if the device is a simulation, or \code{FALSE} if
the device is a physical machine.

\subsection{Compass}{
A list containing constants and their valuse used in the OPI Compass module.
}

\subsection{Octopus600}{
Returns a list of 10 items:
\enumerate{
\item answerButton \{0 = not pressed, 1 = pressed \}
\item headSensor \{0 = no forehead detected, 1 = forehead detected \}
\item eyeLidClosureLeft \{0 = eye is open, 1 = eye is closed\}
\item eyeLidClosureRight \{0 = eye is open, 1 = eye is closed\}
\item fixationLostLeft \{1 = eye pos lost, 0 = eye pos ok\}
\item fixationLostRight \{1 = eye pos lost, 0 = eye pos ok\}
\item pupilPositionXLeft (in px)
\item pupilPositionYLeft (in px)
\item pupilPositionXRight (in px)
\item pupilPositionYRight (in px)
}
}

\subsection{Octopus900}{
list containing \code{isSim=FALSE}.
}
}
\description{
Generic function for getting details of the chosen OPI
implementation that is set with \code{chooseOpi()}
}
\details{
\subsection{Compass}{
Return a list of all the constants used in the OPI Compass module.
}

\subsection{Display}{
Returns all constants in \code{.OpiEnv$Display} as a list.
}
\subsection{Display}{
Returns values in use by Display.
}

\subsection{Daydream}{
Returns all constants in \code{.OpiEnv$DayDream} as a list.
}
\subsection{Daydream}{
DETAILS
}

\subsection{KowaAP7000}{
If the chosen OPI is \code{KowaAP7000}, then this function returns the current
location of the pupil. See the Value section for details.
}
\subsection{KowaAP7000}{
Returns a list of 4 items:
\itemize{
\item \code{pupilX}, the x-coordinate of the pupil position in pixels.
\item \code{pupilY}, the y-coordinate of the pupil position in pixels.
\item \code{purkinjeX}, the x-coordinate of the purkinje position in pixels.
\item \code{purkinjeY}, the y-coordinate of the purkinje position in pixels.
}
It also prints a list of constants that OPI knows about for the AP-7000.
}

\subsection{Octopus600}{
If the chosen OPI is \code{Octopus600}, then this function returns
information about the patient. See the Value section for details.
}

\subsection{Octopus900}{
Prints defined constants in OPI package pertaining to Octopus 900.
}

\subsection{PhoneHMD}{
Returns all constants in \code{.OpiEnv$PhoneHMD} as a list.
}
\subsection{PhoneHMD}{
Returns all constants in \code{.OpiEnv$PhoneHMD} as a list.
}
}
\examples{
chooseOpi("SimGaussian")
if (!is.null(opiInitialize(sd=2)))
  stop("opiInitialize failed")
print(opiQueryDevice())
}
\seealso{
\code{\link{chooseOpi}}
}
