% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeds.R
\docType{data}
\name{seeds}
\alias{seeds}
\title{seeds Data Set}
\format{
A data frame with 209 rows and 7 covariate variables and 1 response variable.
}
\source{
\url{https://archive.ics.uci.edu/ml/datasets/seeds}
}
\description{
Measurements of geometrical properties of kernels belonging to three different varieties of wheat.
A soft X-ray technique and GRAINS package were used to construct all seven, real-valued attributes.
}
\details{
The variables listed below, from left to right, are:
\itemize{
\item area A
\item perimeter P
\item compactness C = 4\emph{pi}A/P^2
\item length of kernel
\item width of kernel
\item asymmetry coefficient
\item length of kernel groove
\item varieties of wheat (1, 2, 3 for Kama, Rosa and Canadian respectively)
}
}
\examples{
data(seeds)
set.seed(221212)
train <- sample(1:209, 80)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])

forest <- ODRF(varieties_of_wheat ~ ., train_data,
  split = "gini", parallel = FALSE, ntrees = 50
)
pred <- predict(forest, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))

tree <- ODT(varieties_of_wheat ~ ., train_data, split = "gini")
pred <- predict(tree, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))
}
\references{
M. Charytanowicz, J. Niewczas, P. Kulczycki, P.A. Kowalski, S. Lukasik, S. Zak, 'A Complete Gradient Clustering Algorithm for Features Analysis of X-ray Images', in: Information Technologies in Biomedicine, Ewa Pietka, Jacek Kawa (eds.), Springer-Verlag, Berlin-Heidelberg, 2010, pp. 15-24.
}
\seealso{
\code{\link{body_fat}} \code{\link{breast_cancer}}
}
\keyword{datasets}
\keyword{internal}
