% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdcc.R
\name{tdcc}
\alias{tdcc}
\title{A Measure of Top-Down Correlation}
\usage{
tdcc(ranks, pearson = FALSE, plot = FALSE)
}
\arguments{
\item{ranks}{[\code{matrix(nrow = b, ncol = k)}]\cr
\code{(bxk)}-matrix of the ranks of the \code{k}
variables for each of the \code{b} SAs, ties are neglected,
must be integers.}

\item{pearson}{[\code{logical(1)}]\cr
logical, should the ordinary Pearson coefficient with
Savage scores be computed (\code{b = 2})?}

\item{plot}{[\code{logical(1)}]\cr
logical, scatter plots showing rankings and Savage scores
(\code{b = 2})?}
}
\value{
A named vector with components:
\itemize{
  \item{\bold{kendall}}: Coefficient of concordance.
  \item{\bold{pearson}}: Pearson Coefficient (only if \code{pearson = TRUE}).
}
}
\description{
The Top-Down Correlation Coefficient TDCC compares \code{b} rankings
using Savage Scores.
}
\details{
NOTE: As the implementation of the coefficient of concordance is still defective,
please use the Pearson coefficient!
}
\examples{
ranking <- rbind(1:20,
                 c(1,3,2,4,16,10,19,12,18,17,
                   20,5,14,7,8,11,6,15,9,13))
tdcc(ranking, pearson = TRUE, plot = TRUE)

}
\references{
Iman and Conover (1987): A Measure of Top-Down Correlation
}
\author{
Stefan Theers
}
