% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareRlaPlots.r
\name{CompareRlaPlots}
\alias{CompareRlaPlots}
\title{compareRlaPlots}
\usage{
CompareRlaPlots(lfeaturedata, groupdata, normmeth = NULL, type = c("ag",
  "wg"), yrange = NULL, plottitle = "RLA plots Comparison",
  saveinteractiveplot = FALSE, savenoninteractive = FALSE,
  interactivesavename = "RlaPlotsComp", ...)
}
\arguments{
\item{lfeaturedata}{A list containing data frames in the featuredata format.}

\item{groupdata}{A vector containing group information.}

\item{normmeth}{A vector with the normalization method used corresponding in order to the 
data supplied to be displayed on the plot.}

\item{type}{A character string indicating whether within group ("\code{wg}")
or across group ("\code{ag}") RLA plots need to be plotted.}

\item{yrange}{A vector with the first entry corresponding to the minimum y-axis value and the second
to the maximum y-axis value to show as default on all the plots. This can be zoomed out 
as the plot is interactive.}

\item{plottitle}{The title to be displayed on the plot.}

\item{saveinteractiveplot}{A boolean indicating whether the interactive plto should be save as a 
\code{.html} file.}

\item{savenoninteractive}{A boolean indicating whether a \code{.png} version of the plto should be save as a.}

\item{interactivesavename}{A character string to be used as the filename for saving the interactive plot.}

\item{...}{Other arguments to \code{\link[NormalizeMets]{RlaPlots}} function.}
}
\description{
Produces within group and across group relative log abundance plots to
visually compare between different normalization methods
}
\examples{
data(UVdata)
# Not RUN due to user input; we set k=1 each and saved normalized data as uv_ruvrandclust
# uv_ruvrand_norm<-NormQcmets(featuredata=UVdata$featuredata,
#                            method="ruvrandclust",
#                            qcmets=which(UVdata$metabolitedata$neg_control==1),
#                            k=1)
data("uv_ruvrandclust")
lfeaturedata<-list(unadj=UVdata$featuredata,ruv=uv_ruvrandclust$featuredata,
   ruvuv=uv_ruvrandclust$uvdata)
#CompareRlaPlots(lfeaturedata,
#                groupdata=interaction(UVdata$sampledata$temperature,UVdata$sampledata$instrument),
#                normmeth=c("Unadjusted:", "RUVrandclust normalized:", 
#                           "RUVrandclust: removed uv:"),
#               yrange=c(-3,3))

}
