% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{lee_weights}
\alias{lee_weights}
\title{Calculates Lee weights}
\usage{
lee_weights(convenience_propensities, reference_propensities, g = 5)
}
\arguments{
\item{convenience_propensities}{A vector with the propensities associated with the convenience sample.}

\item{reference_propensities}{A vector with the propensities associated with the reference sample.}

\item{g}{The number of strata to use; by default, its value is 5.}
}
\value{
A vector with the corresponding weights.
}
\description{
Computes weights from propensity estimates using the propensity stratification design weights averaging formula introduced in Lee (2006) and Lee and Valliant (2009).
}
\details{
The function takes the vector of propensities \eqn{\pi(x)} and calculates the weights to be applied in the Horvitz-Thompson estimator using the formula that can be found in Lee (2006) and Lee and Valliant (2009). The vector of propensities is divided in \emph{g} strata (ideally five according to Cochran, 1968) aiming to have individuals with similar propensities in each strata. After the stratification, weight is calculated as follows for an individual \emph{i}:
\deqn{w_i = \frac{n_r(g_i) / n_r}{n_v(g_i) / n_v}}
where \eqn{g_i} represents the strata to which \emph{i} belongs, \eqn{n_r (g_i)} and \eqn{n_v (g_i)} are the number of individuals in the \eqn{g_i} strata from the reference and the convenience sample respectively, and \eqn{n_r} and \eqn{n_v} are the sample sizes for the reference and the convenience sample respectively.
}
\examples{
covariates = c("education_primaria", "education_secundaria", "education_terciaria")
data_propensities = propensities(sampleNP, sampleP, covariates)
lee_weights(data_propensities$convenience, data_propensities$reference)
}
\references{
Lee, S. (2006). \emph{Propensity score adjustment as a weighting scheme for volunteer panel web surveys.} Journal of official statistics, 22(2), 329.

Lee, S., & Valliant, R. (2009). \emph{Estimation for volunteer panel web surveys using propensity score adjustment and calibration adjustment.} Sociological Methods & Research, 37(3), 319-343.

Cochran, W. G. (1968). \emph{The Effectiveness of Adjustment by Subclassification in Removing Bias in Observational Studies.} Biometrics, 24(2), 295-313
}
