% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-misc.R
\name{keep_if_not_in}
\alias{keep_if_not_in}
\alias{\%if_not_in\%}
\title{Discard elements present in x and not contained in y}
\usage{
keep_if_not_in(x, y)

x \%if_not_in\% y
}
\arguments{
\item{x}{Source vector.}

\item{y}{Destination vector (of the same mode as x).}
}
\value{
A filtered version of x.
}
\description{
Unlike \code{\link[base:sets]{setdiff}}, it does not remove duplicates in x
  and keeps its order.
}
\examples{
keep_if_not_in(1:5, 3:6)
# returns [1 2]

keep_if_not_in(c(4, 3, 4, 3, 1), 3:6)
# returns [1]

}
\seealso{
\code{\link{keep_if_in}}
}
