% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modues.R
\name{te_disc}
\alias{te_disc}
\title{Discrete  Transfer Entropy}
\usage{
te_disc(X, Y, p = 1, q = 1, log = "log2", normalize = FALSE)
}
\arguments{
\item{X}{Integer vector, first time series.}

\item{Y}{Integer vector, the second time series.}

\item{p}{Integer, the lag parameter to use for the first vector (p = 1 by default).}

\item{q}{Integer, the lag parameter to use for the first vector (q = 1 by default)..}

\item{log}{String argument in the set ("log2", "loge","log10"), which indicates the log function to use. The log2 is used by default.}

\item{normalize}{Logical argument  for the option of normalizing the value of TE (transfer entropy) (FALSE by default).
This normalization is done by deviding TE by H (X(t)| X(t-1), ..., X(t-p)), where H is the Shanon entropy.}
}
\description{
Discrete  Transfer Entropy
}
\details{
Computes the Transfer Entropy from the second time series to the one.
}
\examples{
library (NlinTS)
te = te_disc (c(3,2,4,4,3), c(1,4,4,3,3), 1, 1)
print (te)
}
\references{
{
  \insertRef{schreiber2000}{NlinTS}
}
}
