% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CombineSens.R
\name{CombineSens}
\alias{CombineSens}
\title{Sensitivity analysis plot over time of the data}
\usage{
CombineSens(object, comb_type = "mean")
}
\arguments{
\item{object}{\code{list} of \code{data.frames} with the sensitivity measures or
\code{array} with the raw sensitivities calculated with \code{\link[NeuralSens]{SensAnalysisMLP}}}

\item{comb_type}{if \code{object} is \code{array}, function to combine the third dimension of the array.
It can be "mean" or "sqmean". It can also be a function to combine the rows of the array.}
}
\value{
sensitivities of the same type as \code{object} with the combine sensitivities of all outputs
}
\description{
Plot of sensitivity of the neural network output respect
to the inputs over the time variable from the data provided
}
\examples{
\dontrun{
# mod should be a neural network classification model
sens <- SensAnalysisMLP(mod)
combinesens <- CombineSens(sens)
rawsens <- SensAnalysisMLP(mod, .rawSens = TRUE)
meanCombinerawSens <- CombineSens(rawsens, "mean")
sqmeanCombinerawSens <- CombineSens(rawsens, "sqmean")
}
}
