% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{initialise_estimator}
\alias{initialise_estimator}
\title{Initialise a neural estimator}
\usage{
initialise_estimator(
  p,
  architecture,
  d = 1,
  estimator_type = "point",
  depth = 3,
  width = 32,
  activation = "relu",
  activation_output = "identity",
  variance_stabiliser = NULL,
  kernel_size = NULL,
  weight_by_distance = TRUE,
  probs = c(0.025, 0.975)
)
}
\arguments{
\item{p}{number of unknown parameters in the statistical model}

\item{architecture}{a string: for unstructured data, one may use a fully-connected MLP ("MLP"); for data collected over a grid, a convolutional neural network ("CNN"); and for graphical or irregular spatial data, a graphical neural network ("GNN").}

\item{d}{for unstructured multivariate data (i.e., when \code{architecture = "MLP"}), the dimension of the data (e.g., \code{d = 3} for trivariate data); otherwise, if \code{architecture} is \code{"CNN"} or \code{"GNN"}, the argument \code{d} controls the number of input channels (e.g., \code{d = 1} for univariate spatial processes).}

\item{estimator_type}{the type of estimator; either "point" or "interval".}

\item{depth}{the number of hidden layers. Either a single integer or an integer vector of length two specifying the depth of inner (summary) and outer (inference) network of the DeepSets framework. Since there is an input and an output layer, the total number of layers is \code{sum(depth) + 2}.}

\item{width}{a single integer or an integer vector of length \code{sum(depth)} specifying the width (or number of convolutional filters/channels) in each layer.}

\item{activation}{the (non-linear) activation function of each hidden layer. Accepts a string of Julia code (default \code{"relu"}).}

\item{activation_output}{the activation function of the output layer layer. Accepts a string of Julia code (default \code{"identity"}).}

\item{variance_stabiliser}{a function that will be applied directly to the input, usually to stabilise the variance.: a string ('log' for the natural logarithm, or 'cbrt' for the cube-root function), or a string of Julia code that will be converted to a Julia function using \code{juliaEval()}.}

\item{kernel_size}{(applicable only to CNNs) a list of length \code{depth[1]} containing lists of integers of length D, where D is the dimension of the convolution (e.g., D = 2 for two-dimensional convolution).}

\item{weight_by_distance}{(applicable only to GNNs) flag indicating whether the estimator will weight by spatial distance; if true (default), a \code{WeightedGraphConv} layer is used in the propagation module; otherwise, a regular \code{GraphConv} layer is used.}

\item{probs}{(applicable only if \code{estimator_type = "interval"}) probability levels defining the lower and upper endpoints of the posterior credible interval.}
}
\value{
the initialised neural estimator, a JuliaProxy object
}
\description{
Helper function for initialising a neural estimator.

The estimator is couched in the DeepSets framework so that it can be applied to data with an arbitrary number of independent replicates (including the special case of a single replicate).
}
\examples{
\dontrun{
library("NeuralEstimators")
p = 2
initialise_estimator(p, architecture = "MLP")
initialise_estimator(p, architecture = "GNN")

## 1D convolution              
initialise_estimator(p, architecture = "CNN", kernel_size = list(10, 5, 3))

## 2D convolution
initialise_estimator(p, architecture = "CNN", 
                     kernel_size = list(c(10, 10), c(5, 5), c(3, 3)))}
}
