% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stable.R
\name{stable}
\alias{stable}
\title{Stabilizing Nodes}
\usage{
stable(
  A,
  comm = c("walktrap", "louvain"),
  cent = c("betweenness", "rspbc", "closeness", "strength", "degree", "hybrid"),
  absolute = TRUE,
  diagonal = 0,
  ...
)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{Can be a vector of community assignments or community detection algorithms
(\code{"walktrap"} or \code{"louvain"}) can be used to determine the number of factors.
Defaults to \code{"walktrap"}.
Set to \code{"louvain"} for \code{\link[NetworkToolbox]{louvain}} community detection}

\item{cent}{Centrality measure to be used.
Defaults to \code{"strength"}.}

\item{absolute}{Should network use absolute weights?
Defaults to \code{TRUE}.
Set to \code{FALSE} for signed weights}

\item{diagonal}{Sets the diagonal values of the \code{A} input.
Defaults to \code{0}}

\item{...}{Additional arguments for \code{\link[igraph]{cluster_walktrap}}
and \code{\link[NetworkToolbox]{louvain}} community detection algorithms}
}
\value{
A matrix containing the within-community centrality value for each node
}
\description{
Computes the within-community centrality for each node in the network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

stabilizing <- stable(A, comm = "walktrap")

}
\references{
Blanken, T. F., Deserno, M. K., Dalege, J., Borsboom, D., Blanken, P., Kerkhof, G. A., & Cramer, A. O. (2018).
The role of stabilizing and communicating symptoms given overlapping communities in psychopathology networks.
\emph{Scientific Reports}, \emph{8}, 5854.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
