% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{semnetboot}
\alias{semnetboot}
\title{Partial Bootstrapped Semantic Network Analysis}
\usage{
semnetboot(data, method = c("PMFG", "TMFG", "LoGo", "MaST", "threshold"),
  normal = FALSE, nodes, iter = 1000, na.data = c("pairwise", "listwise",
  "fiml", "none"), seeds = NULL, ...)
}
\arguments{
\item{data}{A set of data}

\item{method}{A network filtering method.
Defaults to "PMFG"}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \emph{cor_auto} fucntion from the \emph{qgraph} package)}

\item{nodes}{Number of nodes (i.e., variables) to use in the bootstrap.
Defaults to 50% of nodes in the network.
Otherwise accepts the number of the nodes to be included}

\item{iter}{Number of bootstrap iterations.
Defaults to 1000 iterations}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
If normal is TRUE, then "pairwise" is used.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{seeds}{Seeds to use for random number generation.
Defaults to NULL.
Input seeds from previous run (\strong{see examples})}

\item{...}{Additional arguments for filtering methods}
}
\value{
Returns a list that includes the original semantic network measures (origmeas; ASPL, CC, Q, S),
the bootstrapped semantic network measures (bootmeas),
and the seeds used in the random number generator (Seeds)
}
\description{
Bootstraps (without replacement) the nodes in the network and computes global network characteristics
}
\examples{
\dontrun{
lowO <- subset(animals, Group==1)[-1]

semPMFG<-semnetboot(lowO)

#Replicates previous analysis
repsemPMFG<-semnetboot(lowO, seeds = semPMFG$Seeds)

semLoGo<-semnetboot(lowO,method="LoGo")

semMaST<-semnetboot(lowO,method="MaST")

semThreshold<-semnetboot(lowO,method="threshold")
}
}
\references{
Kenett, Y. N., Wechsler-Kashi, D., Kenett, D. Y., Schwartz, R. G., Ben Jacob, E., & Faust, M. (2013).
Semantic organization in children with cochlear implants: Computational analysis of verbal fluency.
\emph{Frontiers in Psychology}, {4}(543), 1-11.
}
