% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{LoGo}
\alias{LoGo}
\title{Local/Global Sparse Inverse Covariance Matrix}
\usage{
LoGo(data, partial = FALSE, normal = FALSE, na.data = c("pairwise",
  "listwise", "fiml", "none"), graphical = FALSE)
}
\arguments{
\item{data}{Must be a dataset}

\item{partial}{Should the network's connections be the partial correlation between two nodes given all other nodes?
Defaults to FALSE, which returns a sparse inverse covariance matrix.
Set to TRUE for partial correlation matrix}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \emph{cor_auto} fucntion from the \emph{qgraph} package)}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{graphical}{Should network be checked for graphical modeling?
Defaults to FALSE.
Set to TRUE to determine if model is graphical}
}
\value{
Returns a list containing the TMFG-filtered matrix (tmfg)
and the sparse TMFG-filtered inverse covariance matrix (logo).
If normal = TRUE, then shrinkage lambda is also output (lambda)
}
\description{
Applies the Local/Global method to estimate the sparse inverse covariance matrix using a TMFG-filtered network
(see and cite Barfuss et al., 2016)
}
\examples{
LoGonet<-LoGo(neoOpen)$logo

TMFGnet<-LoGo(neoOpen)$tmfg
}
\references{
Barfuss, W., Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Parsimonious modeling with information filtering networks.
\emph{Physical Review E}, \emph{94}(6), 062306.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
