% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkInference.R
\name{NetworkInference}
\alias{NetworkInference}
\title{NetworkInference: Inferring latent diffusion networks}
\description{
This package provides an R implementation of the \code{netinf} algorithm 
created by Gomez Rodriguez, Leskovec, and  Krause (2010). Given a set of
events that spread between a set of nodes the algorithm infers the most likely
stable diffusion network that is underlying the diffusion process.
}
\details{
The package provides three groups of functions: 1) data preparation 
2) estimation and 3) interpretation.
}
\section{Data preparation}{


The core estimation function \code{\link{netinf}} requires an object of class 
\code{cascade} (\link{as.cascade}). Cascade data contains information on the 
potential nodes in the network as well as on event times for each node in each 
cascade. \code{\link{as.cascade}} can handle \code{data.frame} and \code{matrix}
inputs. See the package vignette for more details.
}

\section{Estimation}{


Diffusion networks are estimated using the \code{\link{netinf}} function. It 
produces a diffusion network in form of an edgelist (of class 
\code{\link{data.frame}}).
}

\section{Interpretation and Visualization}{


Cascade data can be visualized with the \code{plot} method of the \code{cascade}
class (\code{diffnet, \link{plot.cascade}}). Results of the estimation process can 
be visualized using the plotting method of the \code{diffnet} class.
}

\section{Performance}{


If higher performance is required and for very large data sets, a faster pure C++ 
implementation is available in the Stanford Network Analysis Project (SNAP). 
The software can be downloaded at \url{http://snap.stanford.edu/netinf/}.
}

