% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{ExtinctionPlot}
\alias{ExtinctionPlot}
\title{Plots the extinctions history of a network}
\usage{
ExtinctionPlot(History, Variable = "AccSecondaryExtinction")
}
\arguments{
\item{History}{a NetworkTopology object obtained from the Mostconnected function
or the ExtinctionOrder function}

\item{Variable}{the variable of the NetworkTopology object that you want as a y variable}
}
\value{
A plot of number of extinctions in the x axis vs the choosen variable in the Y axis
}
\description{
It takes a NetworkTopology class object and plots the network index
after every extinction
}
\examples{
# If you don't specify the y variable it will plot the secondary extinctions
# by default
data("net")
history <- Mostconnected(Network = net)
ExtinctionPlot(History = history)
# You can also specify the variable to be ploted in the y axis
ExtinctionPlot(History = history, Variable = "LinksPerSpecies")
}
\seealso{
[NetworkExtintion::ExtinctionOrder()]
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>

M.Isidora Avila Thieme <msavila@uc.cl>
}
