% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreakDiagnostic.R
\name{BreakDiagnostic}
\alias{BreakDiagnostic}
\title{Detect a break number using different metrics}
\usage{
BreakDiagnostic(Y, R = 2, mcmc = 100, burnin = 100, verbose = 100,
  thin = 1, UL.Normal = "Orthonormal", v0 = NULL, v1 = NULL,
  break.upper = 3, a = 1, b = 1)
}
\arguments{
\item{Y}{Reponse tensor}

\item{R}{Dimension of latent space. The default is 2.}

\item{mcmc}{The number of MCMC iterations after burnin.}

\item{burnin}{The number of burn-in iterations for the sampler.}

\item{verbose}{A switch which determines whether or not the progress of the
sampler is printed to the screen.  If \code{verbose} is greater than 0 the
iteration number, the \eqn{\beta} vector, and the error variance are
printed to the screen every \code{verbose}th iteration.}

\item{thin}{The thinning interval used in the simulation.  The number of
MCMC iterations must be divisible by this value.}

\item{UL.Normal}{Transformation of sampled U. Users can choose "NULL", "Normal" or "Orthonormal."
"NULL" is no normalization. "Normal" is the standard normalization.
"Orthonormal" is the Gram-Schmidt orthgonalization. Default is "NULL."}

\item{v0}{\eqn{v_0/2} is the shape parameter for the inverse
Gamma prior on variance parameters for V.
If \code{v0 = NULL}, a value is computed from a test run of \code{NetworkStatic}.}

\item{v1}{\eqn{v_1/2} is the scale parameter for the
inverse Gamma prior on variance parameters for V.
If \code{v1 = NULL}, a value is computed from a test run of \code{NetworkStatic}.}

\item{break.upper}{Upper threshold for break number detection.
The default is \code{break.upper = 3}.}

\item{a}{\eqn{a} is the shape1 beta prior for transition probabilities. By default,
the expected duration is computed and corresponding a and b values are assigned. The expected
duration is the sample period divided by the number of states.}

\item{b}{\eqn{b} is the shape2 beta prior for transition probabilities. By default,
the expected duration is computed and corresponding a and b values are assigned. The expected
duration is the sample period divided by the number of states.}
}
\description{
Detect a break number using different metrics
}
\examples{
   \dontrun{
   set.seed(19333)
   ## Generate an array (15 by 15 by 20) with a block merging transition
   Y <- MakeBlockNetworkChange(n=5, T=20, type ="merge")

   ## Fit 3 models (no break, one break, and two break) for break number detection 
   detect <- BreakDiagnostic(Y, R=2, break.upper = 2)
   
   ## Look at the graph
   detect[[1]]; print(detect[[2]])

}


}
