% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{beard_cont}
\alias{beard_cont}
\title{Beard descriptions}
\format{
A contingency table (data frame) with 8 rows and 337 columns:
\itemize{
\item rows are the types of beards;
\item columns are the words used at least once to describe them.
}
}
\source{
Applied mathematics department, Institut Agro Rennes-Angers
}
\usage{
beard_cont
}
\description{
These data refer to 8 types of beards.
Each beard was evaluated by 62 assessors (except beard 8 which only had 60 evaluations).
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
data(beard_cont)

FactoMineR::descfreq(beard_cont)

intro_beard <- 'A survey was conducted about beards
and 8 types of beards were described.
In the data that follow, beards are named B1 to B8.'
intro_beard <- gsub('\n', ' ', intro_beard) |>
stringr::str_squish()

req_beard <- 'Please give a name to each beard
and summarize what makes this beard unique.'
req_beard <- gsub('\n', ' ', req_beard) |>
stringr::str_squish()

res_beard <- nail_descfreq(beard_cont,
introduction = intro_beard,
request = req_beard)
cat(res_beard$response)
}
}
\keyword{datasets}
