% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.r
\name{ref.mTAR}
\alias{ref.mTAR}
\title{Refine A Fitted 2-Regime Multivariate TAR Model}
\usage{
ref.mTAR(m1, thres = 1)
}
\arguments{
\item{m1}{a fitted mTAR object.}

\item{thres}{threshold value.}
}
\value{
ref.mTAR returns a list with following components:
\item{data}{data matrix, \code{y}.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{beta}{a (\code{p*k+1})-by-(\code{2k}) matrices. The first \code{k} columns show the estimation results in regime 1, and the second \code{k} columns shows these in regime 2.}
\item{residuals}{estimated innovations.}
\item{sresi}{standard residuals.}
\item{criteria}{overall information criteria.}
}
\description{
Refine a fitted 2-regime multivariate TAR model using "thres" as threshold for t-ratios.
}
\examples{
phi1=matrix(c(0.5,0.7,0.3,0.2),2,2)
phi2=matrix(c(0.4,0.6,0.5,-0.5),2,2)
sigma1=matrix(c(1,0,0,1),2,2)
sigma2=matrix(c(1,0,0,1),2,2)
c1=c(0,0)
c2=c(0,0)
delay=c(1,1)
y=mTAR.sim(100,0,phi1,phi2,sigma1,sigma2,c1,c2,delay,ini=500)
est=mTAR.est(y$series,c(1,1),0,delay)
ref.mTAR(est,0)
}
