% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSglm.test.R
\name{NSglm.test}
\alias{NSglm.test}
\title{Parametric bootstrap-based spatial nonstationarity test for generalized linear mixed model}
\usage{
NSglm.test(
  formula,
  vardir,
  Ni,
  ni,
  lat,
  lon,
  method = "REML",
  maxit = 100,
  precision = 1e-04,
  data
)
}
\arguments{
\item{formula}{an object of class list of formula, describe the model to be fitted}

\item{vardir}{a vector of sampling variances of direct estimators for each small area}

\item{Ni}{a vector of population size for each small area}

\item{ni}{a vector of sample size for each small area}

\item{lat}{a vector of latitude for each small area}

\item{lon}{a vector of longitude for each small area}

\item{method}{type of fitting method, default is "REML" method}

\item{maxit}{number of iterations allowed in the algorithm. Default is 100 iterations}

\item{precision}{convergence tolerance limit for the Fisher-scoring algorithm. Default value is 1e-04}

\item{data}{a data frame comprising the variables named in formula and vardir}
}
\value{
The function returns a list with class "htest" containing the following components:
\describe{
  \item{method}{a character string indicating what type of test was performed.}
  \item{p.value}{the p-value for the test.}
  \item{data.name}{a character string giving the name of the data.}
  }
}
\description{
This function performs a parametric bootstrap-based test procudure for testing spatial nonstationarity in the data.
}
\examples{
# Load data set
data(headcount)
# Testing spatial nonstationarity of the data
result <- NSglm.test(y~x1, var, N,n,lat,long, "REML", 10, 1e-04, headcount[1:10,])
result
}
