% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSAE.R
\docType{package}
\name{NSAE}
\alias{NSAE}
\title{NSAE : Nonstationary Small Area Estimation}
\description{
Executes nonstationary Fay-Herriot model for small area estimation. It produces empirical best linear unbiased predictor (EBLUP) under stationary and nonstationary Fay-Herriot models. This package includes Fay-Herriot model for sample and non-sample area, nonstationary Fay-Herriot model for sample and non-sample area. Functions give EBLUP estimators and mean squared error (MSE) estimator for each model. The nonstationary Fay-Herriot model was developed by Hukum  Chandra, Nicola Salvati and Ray Chambers (2015) <doi:10.1093/jssam/smu026>
}
\section{Author(s)}{

Hukum  Chandra, Nicola Salvati, Ray Chambers, Saurav Guha

{Maintainer}: Saurav Guha \email{saurav.iasri@gmail.com}
}

\section{Functions}{

\describe{
  \item{\code{\link{eblupFH1}}}{Provides the EBLUPs and MSE under stationary Fay-Herriot model for sample area}
  \item{\code{\link{eblupFH2}}}{Provides the EBLUPs and MSE under stationary Fay-Herriot model for sample and non-sample area}
  \item{\code{\link{eblupNSFH1}}}{Provides the EBLUPs and MSE under nonstationary Fay-Herriot model for sample area}
  \item{\code{\link{eblupNSFH2}}}{Provides the EBLUPs and MSE under nonstationary Fay-Herriot model for sample and non-sample area}
}
}

\section{Reference}{

\itemize{
  \item{Chandra, H., Salvati, N., & Chambers, R. (2015). A spatially nonstationary fay-herriot model for small area estimation. Journal of survey statistics and methodology. 3. 109-135. DOI:10.1093/jssam/smu026.}
  \item{Fay, R. E. & Herriot, R. A. (1979). Estimates of Income for Small Places: An Application of James-Stein Procedures to Census Data. Journal of the American Statistical Association. 74. 269-277. DOI:10.2307/2286322.}
  \item{Rao, J.N.K & Molina. (2015). Small Area Estimation 2nd Edition. New York: John Wiley and Sons, Inc.}
  }
}

