% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{PM.matrix}
\alias{PM.matrix}
\title{Partial Moment Matrix}
\usage{
PM.matrix(Co.PM = NULL, LPM.degree, UPM.degree, target, variable,
  pop.adj = FALSE)
}
\arguments{
\item{Co.PM}{options: ("Co.LPM", "Co.UPM", "D.LPM", "D.UPM"); partial moment quadrant to generate matrix of.  \code{NULL} (default) returns all partial moment matrices.}

\item{LPM.degree}{integer; Degree for \code{variable} below \code{target} deviations.  \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{UPM.degree}{integer; Degree for \code{variable} above \code{target} deviations.  \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; Typically the mean of Variable X for classical statistics equivalences, but does not have to be. (Vectorized)  \code{(target = "mean")} will set the target as the mean of every variable.}

\item{variable}{a numeric matrix or data.frame.}

\item{pop.adj}{logical; \code{FALSE} (default) Adjusts the sample co-partial moment matrices for population statistics.}
}
\value{
Matrix of partial moment quadrant values.  Uncalled quadrants will return a matrix of zeros.
}
\description{
This function generates a co-partial moment matrix for the specified co-partial moment.
}
\note{
For divergent asymmetical \code{"D.LPM" and "D.UPM"} matrices, matrix is \code{D.LPM(column,row,...)}.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100); z<-rnorm(100)
A<-cbind(x,y,z)
PM.matrix(LPM.degree=0, UPM.degree=0, target="mean", variable=A)

## Calling Multiple Partial Moment Quadrants
PM.matrix(c("Co.LPM","Co.UPM"), LPM.degree=0, UPM.degree=0, target="mean", variable=A)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{covariance}
\keyword{moments,}
\keyword{partial}
