% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Causation.R
\name{NNS.caus}
\alias{NNS.caus}
\title{NNS Causation}
\usage{
NNS.caus(x, y, tau, plot = FALSE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a numeric vector with compatible dimsensions to \code{x}.}

\item{tau}{integer; Number of lagged observations to consider.}

\item{plot}{logical; \code{FALSE} (default) Plots the raw variables, tau normalized, and cross-normalized variables.}
}
\value{
Returns the directional causation (x ---> y) or (y ---> x) and net quantity of association.  For causal matrix, gross quantity of association is returned as (x[column] ---> y[row]).
}
\description{
Returns the causality from observational data between two variables
}
\examples{
## x clearly causes y...
set.seed(123)
x<-rnorm(100); y<-x^2
NNS.caus(x,y,1)

## Causal matrix
\dontrun{
NNS.caus(data.matrix(iris),tau = 0)
}
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{causation}

