% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.R
\name{VN.ANOVA}
\alias{VN.ANOVA}
\title{VN ANOVA}
\usage{
VN.ANOVA(A, pairwise = FALSE)
}
\arguments{
\item{A}{Matrix of variables.}

\item{pairwise}{Returns pairwise certainty tests when set to TRUE.  Defaults to FALSE.}
}
\value{
Returns the degree certainty the samples belong to the same population [0,1].
}
\description{
Analysis of variance (ANOVA) based on lower partial moment CDFs for multiple variables.  Returns a degree of certainty the samples belong to the same population, not a p-value.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
A<-cbind(x,y)
VN.ANOVA(A,pairwise=TRUE)
mean(na.omit(VN.ANOVA(A,pairwise = TRUE)$x))
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}

