% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMaddSamples.R
\name{NMaddSamples}
\alias{NMaddSamples}
\title{Add simulation (sample) records to dosing records}
\usage{
NMaddSamples(
  data,
  TIME,
  TAPD,
  CMT,
  EVID,
  DV,
  col.id = "ID",
  args.NMexpandDoses,
  unique = TRUE,
  by,
  quiet = FALSE,
  as.fun,
  doses,
  time.sim,
  extras.are.covs
)
}
\arguments{
\item{data}{Nonmem-style data set. If using `TAPD` an `EVID`
column must contain 1 for dosing records.}

\item{TIME}{A numerical vector with simulation times. Can also be
a data.frame in which case it must contain a `TIME` column and
is merged with `data`.}

\item{TAPD}{A numerical vector with simulation times, relative to
previous dose. When this is used, `data` must contain rows
with `EVID=1` events and a `TIME` column. `TAPD` can also be a
data.frame in which case it must contain a `TAPD` column and
is merged with `data`.}

\item{CMT}{The compartment in which to insert the EVID=2
records. Required if `CMT` is a column in `data`. If longer
than one, the records will be repeated in all the specified
compartments. If a data.frame, covariates can be specified.}

\item{EVID}{The value to put in the `EVID` column for the created
rows. Default is 2 but 0 may be prefered even for simulation.}

\item{DV}{Optionally provide a single value to be assigned to the
`DV` column. The default is to assign nothing which will
result in `NA` as samples are stacked (`rbind`) with
`data`. If you assign a different value in `DV`, the default
value of `EVID` changes to `0`, and `MDV` will be `0` instead
of `1`. An example where this is useful is when generating
datasets for `$DESIGN` where `DV=0` is often used.}

\item{col.id}{The name of the column in `data` that holds the
unique subject identifier.}

\item{args.NMexpandDoses}{Only relevant - and likely not needed -
if data contains ADDL and II columns. If those columns are
included, `NMaddSamples()` will use `NMdata::NMexpanDoses()`
to evaluate the time of each dose. Other than the `data`
argument, `NMaddSamples()` relies on the default
`NMexpanDoses()` argument values. If this is insufficient, you
can specify other argument values in a list, or you can call
`NMdata::NMexpanDoses()` manually before calling
`NMaddSamples()`.}

\item{unique}{If `TRUE` (default), events are reduced to unique
time points before insertion. Sometimes, it's easier to
combine sequences of time points that overlap (maybe across
`TIME` and `TAPD`), and let `NMaddSamples()` clean them. If
you want to keep your duplicated events, use `unique=FALSE`.}

\item{by}{If \code{TIME} and/or `TAPD` are `data.frame`s and
contain other columns than `TIME` and/or `TAPD`, those will by
default follow the `TIME`/`TAPD` records. Think of them as
record-level variables, like `VISIT`. The exception is
`col.id` - if the subject identifier is present, it will be
merged by. If additional columns should be used to merge by,
you can use the `by` argument. This is useful to generate
differentiated sampling schemes for subsets of subjects (like
regimen="SAD" and regimen="MAD"). If no columns in `TIME`
and/or `TAPD` should not be merged by, use `by=FALSE`. You can
also specify selected `by` variables like `by="ID"` or
`by=c("ID","regimen")` See examples.}

\item{quiet}{Suppress messages? Default is `FALSE`.}

\item{as.fun}{The default is to return data as a
`data.frame`. Pass a function (say `tibble::as_tibble`) in
as.fun to convert to something else. If data.tables are
wanted, use `as.fun="data.table"`. The default can be
configured using `NMdataConf()`.}

\item{doses}{Deprecated. Use `data`.}

\item{time.sim}{Deprecated. Use `TIME`.}

\item{extras.are.covs}{Deprecated. Use `by`.}
}
\value{
A data.frame with dosing records
only using column names in covs.data (from data) that are not in TIME.

All rows in TIME get reused for all matches by column names common with covs.data - the identified subject-level covariates (and col.id). This is with the exception of the TIME column itself, because in case of single dose, TIME would be carried over.
}
\description{
Adds simulation events to all subjects in a data set. Copies over
columns that are not varying at subject level (i.e. non-variying
covariates). Can add simulation events relative to previous dosing
time. This function was previously called `addEVID2()`.
}
\details{
The resulting data set is ordered by ID, TIME, and
    EVID. You may have to reorder for your specific needs.
}
\examples{
(doses1 <- NMcreateDoses(TIME=c(0,12,24,36),AMT=c(2,1)))
NMaddSamples(doses1,TIME=seq(0,28,by=4),CMT=2)

## two named compartments
dt.doses <- NMcreateDoses(TIME=c(0,12),AMT=10,CMT=1)
seq.time <- c(0,4,12,24)
dt.cmt <- data.frame(CMT=c(2,3),analyte=c("parent","metabolite"))
res <- NMaddSamples(dt.doses,TIME=seq.time,CMT=dt.cmt)

## Separate sampling schemes depending on covariate values
dt.doses <- NMcreateDoses(TIME=data.frame(regimen=c("SD","MD","MD"),TIME=c(0,0,12)),AMT=10,CMT=1)

seq.time.sd <- data.frame(regimen="SD",TIME=seq(0,3))
seq.time.md <- data.frame(regimen="MD",TIME=c(0,12,24))
seq.time <- rbind(seq.time.sd,seq.time.md)
NMaddSamples(dt.doses,TIME=seq.time,CMT=2,by="regimen")

## All subjects get all samples
NMaddSamples(dt.doses,TIME=seq.time,by=FALSE,CMT=2)

## an observed sample scheme and additional simulation times
df.doses <- NMcreateDoses(TIME=0,AMT=50,addl=list(ADDL=2,II=24))
dense <- c(seq(1,3,by=.1),4:6,seq(8,12,by=4),18,24)
trough <- seq(0,3*24,by=24)
sim.extra <- seq(0,(24*3),by=2)
time.all <- c(dense,dense+24*3,trough,sim.extra)
time.all <- sort(unique(time.all))
dt.sample <- data.frame(TIME=time.all)
dt.sample$isobs <- as.numeric(dt.sample$TIME\%in\%c(dense,trough))
dat.sim <- NMaddSamples(dt.doses,TIME=dt.sample,CMT=2)

## TAPD - time after previous dose
df.doses <- NMcreateDoses(TIME=c(0,12),AMT=10,CMT=1)
seq.time <- c(0,4,12,24)
NMaddSamples(df.doses,TAPD=seq.time,CMT=2)

## TIME and TAPD
df.doses <- NMcreateDoses(TIME=c(0,12),AMT=10,CMT=1)
seq.time <- c(0,4,12,24)
NMaddSamples(df.doses,TIME=seq.time,TAPD=3,CMT=2)

## Using a custom DV value affects EVID and MDV 
df.doses <- NMcreateDoses(TIME=c(0,12),AMT=10,CMT=1)
seq.time <- c(4)
NMaddSamples(df.doses,TAPD=seq.time,CMT=2,DV=0)
}
