% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise-covariate.R
\name{covariate_step_tibble}
\alias{covariate_step_tibble}
\title{Prepare forward covariate step}
\usage{
covariate_step_tibble(
  base,
  run_id,
  run_in = nm_dir("models"),
  dtest,
  direction = c("forward", "backward"),
  ...
)
}
\arguments{
\item{base}{An nm object.}

\item{run_id}{Base run_id to construct run_ids of covariate runs.}

\item{run_in}{Character.  See \code{\link[=run_in]{run_in()}}.}

\item{dtest}{\code{dplyr::tibble} with testing relations (from
\code{\link[=test_relations]{test_relations()}}).}

\item{direction}{Character. \code{"forward"} (default) or \code{"backward"}.}

\item{...}{Additional arguments passed to \code{\link[=add_cov]{add_cov()}}.}
}
\value{
Will return \code{dtest} a \code{dplyr::tibble} with appended columns.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Takes a base nm object and a set of relationships to test (from
\code{\link[=test_relations]{test_relations()}}) and prepares a \code{tibble} of NONMEM runs.

The goal of NMproject's covariate modelling functions is to provide a
stepwise covariate method \emph{with manual decision} making.  This important to
ensure that the full model selection/evaluation criteria (should be defined
in statistical analysis plans) can be applied at every step rather than just
log likelihood ratio testing, where the most significant model may be
unstable, may worsen model predictions or may only be slightly more
significant than a more physiologically plausible covariate relationship.

The functions \code{\link[=test_relations]{test_relations()}}, \code{\link[=covariate_step_tibble]{covariate_step_tibble()}},
\code{\link[=bind_covariate_results]{bind_covariate_results()}} together comprise NMproject stepwise covariate
method with manual decision.  The goal is to be part way between PsN's SCM
and completely manual process at each forward and backward elimination step.
The syntax of how covariates are included is the same as PsN's SCM routine -
See \href{https://uupharmacometrics.github.io/PsN/docs.html}{PsN documentation}
for more information.
}
\examples{

dtest <- test_relations(param = c("KA", "K", "V"),
                        cov = c("LIN1", "LIN2", "LIN3", "RND1", "RND2", "RND3"),
                        state = c("linear", "power"),
                        continuous = TRUE) \%>\%
         test_relations(param = c("KA", "K", "V"),
                        cov = "BN1",
                        state = "linear",
                        continuous = FALSE)
                        
# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

temp_data_file <- paste0(tempfile(), ".csv")

## dataset has missing WTs so create a new one and assign this to the run
input_data(m1) \%>\% 
  dplyr::group_by(ID) \%>\%
  dplyr::mutate(WT = na.omit(WT)) \%>\%
  write_derived_data(temp_data_file)
  
m1 <- m1 \%>\% data_path(temp_data_file)
 
dtest <- test_relations(param = c("K", "V"),
                        cov = c("WT"),
                        state = c("linear", "power"),
                        continuous = TRUE)

## requires NONMEM to be installed
\dontrun{
## create tibble of covariate step with model objects as column m
dsm1 <- m1 \%>\% covariate_step_tibble(run_id = "m1_f1",
                                     dtest = dtest,
                                     direction = "forward")

## run all models greedily
dsm1$m <- dsm1$m \%>\% run_nm()

## extract results and put into tibble
dsm1 <- dsm1 \%>\% bind_covariate_results()

## sort by BIC (for example) and view
dsm1 <- dsm1 \%>\% arrange(BIC)
dsm1

## check condition number, covariance,...
## run any diagnostics here

## when happy with selection, select run for subsequent step

m1_f1 <- dsm1$m[1] ## select most signifcant BIC
# alternative select by relationship
m1_f1 <- dsm1 \%>\%
  filter(param = "CL", cov = "BWT", state = "power") \%$\%
  m

## do next forward step

dsm2 <- m1_f1 \%>\% covariate_step_tibble(run_id = "m1_f2",
                                        dtest = dtest,
                                        direction = "forward")

## continue ...
}
}
\seealso{
\code{\link[=test_relations]{test_relations()}}, \code{\link[=bind_covariate_results]{bind_covariate_results()}}, \code{\link[=add_cov]{add_cov()}}
}
