% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-code.R
\name{code_library}
\alias{code_library}
\title{Code Library}
\usage{
code_library(
  extn = NULL,
  fields = "Description",
  viewer = TRUE,
  silent = FALSE,
  return_info = FALSE
)
}
\arguments{
\item{extn}{Vector string of extensions to include (default = \code{NULL} includes
all).}

\item{fields}{Character vector of fields to extract.}

\item{viewer}{Logical indicating if viewer should be used to display results
(default=\code{FALSE}).}

\item{silent}{Logical indicating if messages should be silenced
(default=\code{FALSE}).}

\item{return_info}{Logical (default = \code{FALSE}). Return data.frame of results
(FALSE= returns file paths).}
}
\value{
If \code{return_info = TRUE}, invisibly returns output a \code{tibble} with
code library information.  Otherwise (this may be deprecated soon), will return paths to code library
files.
}
\description{
Function not designed for direct use.  Instead use the RStudio \verb{code library}
entry on the RStudio 'Addins' menu. This will open the shiny app. Select the file, and
click "preview" to view and \code{\link[=import]{import()}} to bring into the "staging" area of
your project.  See vignette at \url{https://tsahota.github.io/NMproject/} for a
video showing use of the app. NONMEM control files will intentionally not be
imported straight in the "Models" directory and instead go into
"staging/Models".  This staging location can be referred to when creating
\code{nm} objects with \code{new_nm(..., based_on = "staging/Models/[filename]")}.
}
\details{
Requires \code{getOption("code_library_path")} to be set.
}
\examples{

code_library(viewer = FALSE, return_info = TRUE)

}
\seealso{
\code{\link[=ls_code_library]{ls_code_library()}}, \code{\link[=stage]{stage()}}, \code{\link[=import]{import()}}
}
