% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate-explore.R
\name{cov_forest_data}
\alias{cov_forest_data}
\title{Produce dataset for covariate forest plotting}
\usage{
cov_forest_data(m, covariate_scenarios)
}
\arguments{
\item{m}{An nm object.}

\item{covariate_scenarios}{A \code{data.frame}. Need columns \code{cov}, \code{value}
and (optional) \code{text}.  See details for more information.}
}
\value{
\code{dplyr::tibble} with quantile information suitable for
\code{\link[=cov_forest_plot]{cov_forest_plot()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The main workhorse for computing uncertainty quantiles of covariate effects
in different subpopulations.
}
\details{
The column \code{cov} in \code{covariate_scenarios} refers to covariate
variables in the dataset. The column \code{value} refers to covariate values of
importance.  Typically these will be quantiles of continuous variables and
categories (for categorical covariates). The column \code{text} is option but is
a labelling column for \code{\link[=cov_forest_plot]{cov_forest_plot()}} to adjust how the covariate
scenarios are printed on the axis
}
\examples{

## requires NONMEM to be installed
\dontrun{

dcov <- input_data(m1, filter = TRUE)
dcov <- dcov[!duplicated(dcov$ID), ]

covariate_scenarios <- dplyr::bind_rows(
  dplyr::tibble(cov = "HEALTHGP", value = c(0, 1)),
  dplyr::tibble(cov = "HEPATIC", value = unique(dcov$HEPATIC[dcov$HEPATIC > -99])),
  dplyr::tibble(cov = "BWTIMP", value = c(50, 80, 120)),
  dplyr::tibble(cov = "ECOG", value = c(0, 1, 2, 3)),
  dplyr::tibble(cov = "BEGFRIMP", value = quantile(dcov$BEGFR[dcov$BEGFR > -99])),
  dplyr::tibble(cov = "RACE", value = c(1, 2), text = c("white", "black")),
  dplyr::tibble(cov = "PPI", value = c(0, 1)),
  dplyr::tibble(cov = "H2RA", value = c(0, 1))
)

dplot <- cov_forest_data(m1, covariate_scenarios = covariate_scenarios)
cov_forest_plot(dplot)
}

}
