% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm_object.R
\name{nm_list_gather}
\alias{nm_list_gather}
\title{Get all nm_list objects}
\usage{
nm_list_gather(x = .GlobalEnv)
}
\arguments{
\item{x}{An environment (default = \code{.GlobalEnv}) to search
or \code{data.frame} with (\code{nm_list} column) or \code{nm_list}.}
}
\value{
A single \code{nm_list} object with all model objects in environment \code{x}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get all nm objects in an environment.  By default this is the global
workspace.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m2 <- m1 \%>\% child("m2")

m_all <- nm_list_gather()

identical(
  m_all \%>\% subset(run_id(m_all) \%in\% "m1"),
  m1
)

}
