% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise-covariate.R
\name{bind_covariate_results}
\alias{bind_covariate_results}
\title{Add run results into a covariate tibble}
\usage{
bind_covariate_results(dsc, nm_col = "m", parameters = "new")
}
\arguments{
\item{dsc}{An output \code{tibble} from \code{\link[=covariate_step_tibble]{covariate_step_tibble()}}.}

\item{nm_col}{Character (default = \code{"m"}). Name of column to store nm objects.}

\item{parameters}{Character (default = \code{"new"}).  Passed to \code{\link[=summary_wide]{summary_wide()}}.}
}
\value{
An modified version of \code{dsc} with additional columns from
\code{\link[=summary_wide]{summary_wide()}} for model selection purposes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Extracts results from completed covariate runs and combines them into the
covariate \code{\link[=tibble]{tibble()}}.

The goal of NMproject's covariate modelling functions is to provide a
stepwise covariate method \emph{with manual decision} making.  This important to
ensure that the full model selection/evaluation criteria (should be defined
in statistical analysis plans) can be applied at every step rather than just
log likelihood ratio testing, where the most significant model may be
unstable, may worsen model predictions or may only be slightly more
significant than a more physiologically plausible covariate relationship.

The functions \code{\link[=test_relations]{test_relations()}}, \code{\link[=covariate_step_tibble]{covariate_step_tibble()}},
\code{\link[=bind_covariate_results]{bind_covariate_results()}} together comprise NMproject stepwise covariate
method with manual decision.  The goal is to be part way between PsN's SCM
and completely manual process at each forward and backward elimination step.
The syntax of how covariates are included is the same as PsN's SCM routine -
See \href{https://uupharmacometrics.github.io/PsN/docs.html}{PsN documentation}
for more information.
}
\examples{

## requires NONMEM to be installed
\dontrun{
## create tibble of covariate step with model objects as column m
dsm1 <- m1 \%>\% covariate_step_tibble(
  run_id = "m1_f1",
  dtest = dtest,
  direction = "forward"
)

## run all models greedily
dsm1$m <- dsm1$m \%>\% run_nm()

wait_finish(dsm1$m)

## extract results and put into tibble
dsm1 <- dsm1 \%>\% bind_covariate_results()

## plot goodness of fit diagnostics top 3 models (in terms of p-value)
dsm1$m[1:3] \%>\% nm_render("Scripts/basic_gof.Rmd")

}
}
\seealso{
\code{\link[=covariate_step_tibble]{covariate_step_tibble()}} and \code{\link[=nm_render]{nm_render()}} for rendering diagnostic
reports for (subsets of) models in \code{nm_col}.
}
