% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findCovs.R
\name{findCovs}
\alias{findCovs}
\title{Extract columns that do not vary within variables in data}
\usage{
findCovs(data, by = NULL, as.fun = NULL)
}
\arguments{
\item{data}{data.frame in which to look for covariates}

\item{by}{covariates will be searched for in combinations of values in
these columns. Often by will be either empty or ID. But it can also
be both say c("ID","DRUG") or c("ID","TRT").}

\item{as.fun}{The default is to return a data.table if data is a data.table
and return a data.frame in all other cases. Pass a function in as.fun to
convert to something else. If data is not a data.table, the default can
be configued using NMdataConf.}
}
\value{
a data set with one observation per combination of values of
    variables listed in by.
}
\description{
This function provides an automated method to extract covariate-like
columns. The user decides which columns these variables cannot vary
within. So if you have repeated measures for each ID, this function can find
the columns that are constant within ID and their unique values for each
ID. Or, you can provide a combination of id.cols, say ID and STUDY, and get
variables that do not vary within unique combinations of these.
}
\examples{
dat <- NMscanData(system.file("examples/nonmem/xgxr001.lst", package = "NMdata"))
### very common use
findCovs(dat,by="ID")
### Without an ID column we get non-varying columns
findCovs(dat)
}
\seealso{
Other DataCreate: 
\code{\link{NMorderColumns}()},
\code{\link{NMstamp}()},
\code{\link{findVars}()},
\code{\link{flagsAssign}()},
\code{\link{flagsCount}()},
\code{\link{mergeCheck}()},
\code{\link{tmpcol}()}
}
\concept{DataCreate}
