% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_bootstrap.R
\name{bootstrap_variance}
\alias{bootstrap_variance}
\title{Shared bootstrap variance helpers}
\usage{
bootstrap_variance(data, estimator_func, point_estimate, ...)
}
\arguments{
\item{data}{A \code{data.frame} or a \code{survey.design}.}

\item{estimator_func}{Function returning an object with a numeric scalar
component \code{y_hat} and an optional logical component \code{converged}.}

\item{point_estimate}{Numeric scalar; used for survey bootstrap variance
(passed to \code{survey::svrVar()} as \code{coef}).}

\item{...}{Additional arguments. Some are consumed by \code{bootstrap_variance()}
itself (for example \code{resample_guard} for IID bootstrap or
\code{bootstrap_settings}/\code{bootstrap_options}/\code{bootstrap_type}/\code{bootstrap_mse}
for survey bootstrap); remaining arguments are forwarded to \code{estimator_func}.}
}
\description{
Internal helpers to estimate the variance of a scalar estimator
  via bootstrap resampling (IID data) or bootstrap replicate weights
  (survey designs). Designed to be reused across NMAR engines.
}
\details{
\itemize{
    \item For \code{data.frame} inputs, performs IID bootstrap by resampling
      rows and rerunning \code{estimator_func} on each resample, then
      computing the empirical variance of the replicate estimates.
    \item For \code{survey.design} inputs, converts the design to a bootstrap
      replicate-weight design with \code{svrep::as_bootstrap_design()},
      evaluates \code{estimator_func} on each replicate weight vector (by
      injecting the replicate analysis weights into a copy of the input design), and
      passes the resulting replicate estimates and replicate scaling factors
      to \code{survey::svrVar()}.
  }

  \code{estimator_func} is typically an engine-level estimator (for example
  the EL engine) and is called with the same arguments used for the point
  estimate, except that the \code{data} argument is replaced by the resampled
  data (IID) or a replicate-weighted \code{survey.design} (survey). Arguments
  reserved for the bootstrap implementation are stripped from \code{...}
  before forwarding.
}
\section{Bootstrap-specific options}{

  \describe{
    \item{\code{resample_guard}}{IID bootstrap only. A function
      \code{function(indices, data)} that returns \code{TRUE} to accept a
      resample and \code{FALSE} to reject it.}
    \item{\code{bootstrap_settings}}{Survey bootstrap only. A list of
      arguments forwarded to \code{svrep::as_bootstrap_design()}.}
    \item{\code{bootstrap_options}}{Alias for \code{bootstrap_settings}.}
    \item{\code{bootstrap_type}}{Shortcut for the \code{type} argument to
      \code{svrep::as_bootstrap_design()}.}
    \item{\code{bootstrap_mse}}{Shortcut for the \code{mse} argument to
      \code{svrep::as_bootstrap_design()}.}
  }
}

\section{Progress Reporting}{

  If the optional \code{progressr} package is installed, bootstrap calls
  signal progress via a \code{progressr::progressor} inside
  \code{progressr::with_progress()}. Users control whether progress is shown
  (and how) by registering handlers with \code{progressr::handlers()}. When
  \code{progressr} is not installed or no handlers are active, bootstrap runs
  silently. Progress reporting is compatible with all future backends.
}

\section{Reproducibility}{

  For reproducible bootstrap results, always set a seed before calling
  the estimation function:

  \preformatted{
  set.seed(123)  # Set seed for reproducibility
  result <- nmar(Y ~ X, data = df,
                 engine = el_engine(variance_method = "bootstrap",
                                    bootstrap_reps = 500))
  }

  The \code{future} framework (via \code{future.seed = TRUE} in
  \code{future.apply::future_lapply()}) ensures that each bootstrap replicate
  uses an independent L'Ecuyer-CMRG random number stream derived from this
  seed. This gives reproducible results across supported future backends
  (sequential, multisession, cluster, and so on).
}

\keyword{internal}
