% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transf_label}
\alias{transf_label}
\title{Add variable/value labels}
\usage{
transf_label(
  data,
  study,
  release = "latest",
  add_var_label = TRUE,
  add_value_label = TRUE,
  id_cols_labels = c(participant_id = "Participant identifier", session_id =
    "Event identifier", run_id = "Run identifier")
)
}
\arguments{
\item{data}{tibble. The data to be transformed.}

\item{study}{character. NBDC study (One of \code{"abcd"} or \code{"hbcd"}.}

\item{release}{character. Release version (Default: \code{"latest"}).}

\item{add_var_label}{logical. Whether to add variable labels (Default:
\code{TRUE}).}

\item{add_value_label}{logical. Whether to add value labels (Default:
\code{TRUE}).}

\item{id_cols_labels}{named character vector. A named vector of labels for
the identifier columns, with the names being the column names and the
values being the labels.}
}
\value{
A tibble with the labelled data.
}
\description{
This function can add variable labels and value labels to the
data. The variable labels are descriptive information about the column,
and the value labels are the levels of the factor variables.
}
\details{
\subsection{Two types of labels}{

At least one of \code{add_var_label} or \code{add_value_label} must be set to \code{TRUE}.
If both are \code{FALSE}, an error will be raised.
}

\subsection{Text columns}{

The \code{\link[=transf_factor]{transf_factor()}} function has a \code{convert_text} argument,
which will convert text columns to unordered factors. When one uses
a type transformed data to add labels, the text-factor columns
will not have labels at variable level.
}
}
\examples{
\dontrun{
transf_label(data)
}
}
\seealso{
\code{\link[=transf_factor]{transf_factor()}} for transforming categorical columns to factors.
}
